/* digitemAN -- display annotations */

/* version 1.0 - M.A. Huckvale - July 1987 */

#include <stdio.h>
#include <fcntl.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

#define MAXANLEVELS	20

#ifdef __STDC__
int    digitemAN(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,struct an_rec *buff,double    start,double   stop,int  flags)
#else
int digitemAN(bundles,xl,yb,xr,yt,item,buff,start,stop,flags)
int32		bundles;
float		xl,yb,xr,yt;
struct item_header *item;
struct an_rec 	*buff;
double		start,stop;
int		flags;
#endif
{
	register int	i;
	int		x,y;
	int		level;
	int		lastx[MAXANLEVELS];
	int		bmark,tmark;
	double		time;

	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,start,stop,flags);
	xl += digitab.ixoff/digdata.xscale;

	/* write axis label */
	y = (digitab.iyt + digitab.iyb - digdata.chheight)/2;
	digtextp(digitab.lbun,digitab.ixl+3,y,"An");

	/* calc line positions */
	bmark = digitab.iyb+1;
	tmark = digitab.iyt;

	/* draw graph */
	for (level=0;level<MAXANLEVELS;level++) lastx[level]=0;
	level=0;
	i=0;
	time=buff[i].posn*item->frameduration+item->offset;
	while ((i<item->numframes) && (time<stop)) {
		if (time >=start) {
			x = digitab.ixl+digitab.ixoff + (time-start) * digitab.scalex * digdata.xscale;
			if (x <= lastx[level]) {
				/* overlap on this level - move text up */
				level++;
				y = bmark + level*digdata.chheight;
				/* but not too high */
				if (((y+digdata.chheight) >= tmark) ||
				    (level >= MAXANLEVELS)) {
				    	/* can't fit, reset everything */
					y = bmark;
					level=0;
				}
			}
			else {
				/* drop down until hit annotation */
				while ((level > 0) && (x > lastx[level-1])) level--;
				y = bmark + level*digdata.chheight;
			}
			diglinep(digitab.gbun,x,y,x,tmark);
			digtextp(digitab.lbun,x+2,y+1,buff[i].label);
			x += digdata.chwidth*strlen(buff[i].label);
			if (x > lastx[level])
				/* this annotation is right-most at this level */
				lastx[level] = x;
		}
		time=buff[++i].posn*item->frameduration+item->offset;
	}

	/* draw title if required */
	digititle(item,flags);

	/* that's it */
	digflush();
	return(0);
}

#ifdef EMO
char	*progname="digitemAN";
main(argc,argv)
int	argc;
char	*argv[];
{
	struct	item_header item,anitem;
	short	*buff;
	struct an_rec *an;
	double	totime;

	if (strcmp(argv[1],"-p")==0) {
		digstart('k',NULL,1);
		getitem(argv[2],SP_TYPE,"*",&item,&buff);
		getitem(argv[2],AN_TYPE,"*",&anitem,&an);
	}
	else {
		digstart('\0',NULL,1);
		getitem(argv[1],SP_TYPE,"*",&item,&buff);
		getitem(argv[1],AN_TYPE,"*",&anitem,&an);
	}

	digscale(10.0,10.0,0);
	digclearscreen();

	totime = item.numframes*item.frameduration;
	digitemtime(23,0.0,9.0,10.0,9.5,0.0,totime,1);
	digitemSP(20,0.0,7.0,10.0,9.0,&item,buff,0.0,totime,3);
	digitemAN(20,0.0,6.0,10.0,7.0,&anitem,an,0.0,totime,3);

	digitemtime(23,0.0,5.0,10.0,5.5,totime/2,totime+0.25,1);
	digitemSP(20,0.0,3.0,10.0,5.0,&item,buff,totime/2,totime+0.25,3);
	digitemAN(20,0.0,2.0,10.0,5.0,&anitem,an,totime/2,totime+0.25,9);

	digend();
	exit(0);
}
#endif
