/* digitemDI -- grey level displays */

/* version 1.0 - M.A. Huckvale - November 1987 */

#include <stdio.h>
#include <fcntl.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

#ifdef __STDC__
int    digitemDI(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,struct di_rec *buff,double    start,double   stop,int  flags)
#else
int digitemDI(bundles,xl,yb,xr,yt,item,buff,start,stop,flags)
int32		bundles;
float		xl,yb,xr,yt;
struct item_header *item;
struct di_rec	*buff;
double		start,stop;
int		flags;
#endif
{
	int	y;
	int	numf,bstart;
	float	dstart,dstop;
	char	*labels=NULL;

	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,start,stop,flags);
	xl += digitab.ixoff/digdata.xscale;
	yt = yval(digitab.iyt);

	/* check timing of data set */
	dstart=item->offset+buff[0].posn*item->frameduration;
	bstart=0;
	while ((dstart < start) && (bstart<(item->numframes-1))) {
		bstart++;
		dstart = item->offset + buff[bstart].posn*item->frameduration;
	}
	dstop=item->offset+(buff[bstart].posn)*item->frameduration;
	numf=0;
	while ((dstop < stop) && ((bstart+numf) < (item->numframes-1))) {
		numf++;
		dstop = item->offset + (buff[bstart+numf].posn)*item->frameduration;
	}
	if (dstop < stop) {
		/* data does not reach to right end */
		xr = xl + (dstop-start)*digitab.scalex;
	}
	if (dstart > start) {
		/* data does not reach to left end */
		xl += (dstart-start)*digitab.scalex;
	}

	/* display, if anything left */
	if ((numf>0) && (bstart<item->numframes)) {

		/* get max and min values */
		if (!(flags & DIGITEMFIX)) {
			if ((labels=params(item->params,"labels",NULL))==NULL) {
				digitab.lo = param(item->params,"minf",0.0);
				digitab.hi = param(item->params,"maxf",0.5/item->frameduration);
			}
		}

		/* write y-axis */
		if ((flags & DIGITEMFIX) || (labels==NULL)) {
			digitemfreq(bundles,digitab.iyb,digitab.iyt,digitab.lo,digitab.hi,1);
			/* write axis label */
			y = (digitab.iyt + digitab.iyb - digdata.chheight)/2;
			digtextp(digitab.dbun,digitab.ixl+3,y,"Hz");
		}
		else
			digitemlabel(bundles,digitab.iyb,digitab.iyt,labels,0,item->framesize-sfsstruct[DI_TYPE]);

		/* draw graph */
		diggreyscale(digitab.gbun,xl,yb,xr,yt,buff[bstart].pixel,numf,item->framesize-sfsstruct[DI_TYPE],16);

	}

	/* draw title if required */
	digititle(item,flags);

	/* that's it */
	digflush();
	return(0);
}

#ifdef EMO
char	*progname="digitemDI";
main(argc,argv)
int	argc;
char	*argv[];
{
	struct	item_header item;
	struct di_rec	*buff;
	double	totime;

	digstart('\0',NULL,1);
	getitem(argv[1],DI_TYPE,"*",&item,&buff);

	digscale(10.0,10.0,0);
	digclearscreen();

	totime = (buff[item.numframes-1].posn+buff[item.numframes-1].size)*item.frameduration;
	digitemtime(23,0.0,9.0,10.0,9.5,0.0,totime,1);
	digitemDI(20,0.0,7.0,10.0,9.0,&item,buff,0.0,totime,3);

	digitemtime(23,0.0,6.0,10.0,6.5,totime-0.25,totime+0.25,1);
	digitemDI(20,0.0,4.0,10.0,6.0,&item,buff,totime-0.25,totime+0.25,3);

	digitemtime(23,0.0,3.0,10.0,3.5,0.0,0.1,1);
	item.offset=0.05;
	digitemDI(20,0.0,1.0,10.0,3.0,&item,buff,0.0,0.1,3);

	digquit(15);
	exit(0);
}
#endif
