/* digitfreq -- y-axis display for digitem library */

/* version 1.0 - M.A.Huckvale - November 1987 */

#include <stdio.h>
#include <fcntl.h>
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

static struct {
	double	unit;		/* units for scale factor */
	double	scale;		/* scale factor */
	char	*label;		/* scale label */
	char	*format;	/* printf format */
} unitab[]=
{
	{ 5000000.0,1000000.0,	"M",	"%.0f" },
	{ 2000000.0,1000000.0,	"M",	"%.0f" },
	{ 1000000.0,1000000.0,	"M",	"%.0f" },
	{ 500000.0,1000000.0,	"M",	"%.1f" },
	{ 200000.0,1000000.0,	"M",	"%.1f" },
	{ 100000.0,1000000.0,	"M",	"%.1f" },
	{ 50000.0,1000.0,	"k",	"%.0f" },
	{ 20000.0,1000.0,	"k",	"%.0f" },
	{ 10000.0,1000.0,	"k",	"%.0f" },
	{ 5000.0,	1000.0,	"k",	"%.0f" },
	{ 2000.0,	1000.0,	"k",	"%.0f" },
	{ 1000.0,	1000.0,	"k",	"%.0f" },
	{ 500.0,	1.0,	"",	"%.0f" },
	{ 200.0,	1.0,	"",	"%.0f" },
	{ 100.0,	1.0,	"",	"%.0f" },
	{ 50.0,	1.0,	"",	"%.0f" },
	{ 20.0,	1.0,	"",	"%.0f" },
	{ 10.0,	1.0,	"",	"%.0f" },
	{ 5.0,	1.0,	"",	"%.0f" },
	{ 2.0,	1.0,	"",	"%.0f" },
	{ 1.0,	1.0,	"",	"%.0f" },
	{ 0.5,	1.0,	"",	"%.1f" },
	{ 0.2,	1.0,	"",	"%.1f" },
	{ 0.1,	1.0,	"",	"%.1f" },
	{ 0.05,	0.001,	"m",	"%.0f" },
	{ 0.02,	0.001,	"m",	"%.0f" },
	{ 0.01,	0.001,	"m",	"%.0f" },
	{ 0.005,	0.001,	"m",	"%.0f" },
	{ 0.002,	0.001,	"m",	"%.0f" },
	{ 0.001,	0.001,	"m",	"%.0f" },
	{ 0.0005,	0.001,	"m",	"%.1f" },
	{ 0.0002,	0.001,	"m",	"%.1f" },
	{ 0.0001,	0.001,	"m",	"%.1f" },
	{ 0.00005,0.000001,"u",	"%.0f" },
	{ 0.00002,0.000001,"u",	"%.0f" },
	{ 0.00001,0.000001,"u",	"%.0f" },
	{ 0.0,	0.000001,"u",	"%.1f" },
};

/* grid points for external access */
int	digit_ygrid[100];	
int	digit_nygrid;
	
int digitemfreq(bundles,iyb,iyt,start,stop,flags)
int32	bundles;	/* colours: 10000*divisions + 100*labels + title */
int	iyb,iyt;	/* pixel y values */
double	start,stop;	/* start, stop value  */
int	flags;		/* format flags */
{
	int	scale;
	int	ixm1,ixm2,ixm3;
	double	unitval,tenthval,offset,t,scaley;
	int	x,y,marks=0,fifths=0;
	char	str[32];
	float	digtextlen();

	/* calc "ixm1" - left of small markers */
	ixm1 = digitab.ixl + digitab.ixoff - digdata.chwidth/2;
	/* calc "ixm2" - left of medium markers */
	ixm2 = digitab.ixl + digitab.ixoff - digdata.chwidth;
	/* calc "ixm3" - left of large markers */
	ixm3 = digitab.ixl + digitab.ixoff - digdata.chwidth*3/2;

	/* determine how many timing markers */
	/* -- go for 1 marker every 4 or so h/w text chars */
	unitval = 4 * digdata.chheight * (stop - start) / (iyt-iyb);
	for (scale=0;(unitab[scale].unit > 0) && (unitab[scale].unit > unitval);scale++) ;
	if (unitab[scale].unit==0) return(-1);
	if (((stop-start)/unitab[scale].unit) < 3) fifths++;
	unitval=unitab[scale].unit;
	tenthval=unitval/10;

	/* calculate offset time of scale */
	offset = ((int)(start/unitval))*unitval + unitval - start;
	if (offset==unitval) offset=0.0;
	marks = 10 - (int)(10*offset/unitval);
	offset = ((int)(start/tenthval))*tenthval + tenthval - start;
	if (offset==tenthval) offset=0.0;

	/* display freq scale */
	scaley = (double)(iyt - iyb)/(stop-start);
	stop -= start;
	digit_nygrid=0;
	for (t = offset; t < stop; t += tenthval) {
		y = iyb + t * scaley;
		if ((marks % 10)==0) {
			diglinep(digitab.dbun,ixm3,y,digitab.ixl+digitab.ixoff,y);
			sprintf(str,unitab[scale].format,(start+t)/unitab[scale].scale);
			strcat(str,unitab[scale].label);
			if (((y + digdata.chheight/2) < digitab.iyt) &&
			    ((y - digdata.chheight/2) > digitab.iyb)) {
				x = ixm3 - digtextlen(str)*digdata.xscale;
				digtextp(digitab.dbun,x-3,y-digdata.chheight/2,str);
			}
			digit_ygrid[digit_nygrid++]=y;
		}
		else if ((marks % 10)==5) {
			diglinep(digitab.dbun,ixm2,y,digitab.ixl+digitab.ixoff,y);
			if (fifths) {
				sprintf(str,unitab[scale+1].format,(start+t)/unitab[scale+1].scale);
				strcat(str,unitab[scale+1].label);
				if (((y + digdata.chheight/2) < digitab.iyt) &&
				    ((y - digdata.chheight/2) > digitab.iyb)) {
					x = ixm3 - digtextlen(str)*digdata.xscale;
					digtextp(digitab.dbun,x-3,y-digdata.chheight/2,str);
				}
			}
		}
		else
			diglinep(digitab.dbun,ixm1,y,digitab.ixl+digitab.ixoff,y);
		marks++;
	}

	return(0);
}

#ifdef EMO
digitfreq(bundles,xl,yb,xr,yt,start,stop,flags)
int	bundles,flags;
float	xl,yb,xr,yt;
double	start,stop;
{
	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,start,stop,flags);

	/* draw freq axis */
	digitemfreq(bundles,digitab.iyb,digitab.iyt,start,stop,flags);
}

main ()
{

	digstart('\0',NULL,1);
	digscale(100.0,100.0,0);
	digclearscreen();

	digitfreq(222120,  0.0,  0.0, 20.0,100.0,0.0,10.0,1);
	digitfreq(222120, 20.0,  0.0, 40.0, 90.0,-1000.0,1000.00,1);
	digitfreq(222120, 40.0,  0.0, 60.0, 80.0,-0.00045,0.0001,1);
	digitfreq(222120, 60.0,  0.0, 80.0, 70.0,1.65,10.2,1);
	digitfreq(222120, 80.0, 10.0,100.0, 60.0,9.5,10.0,1);
	digitfreq(222120, 80.0, 60.0,100.0, 80.0,0.0,2.0,1);

	digend();
}
#endif
