/*  digitemFX -- fx display  */

/*  version 1.1 - November 1987
	- SFS version
*/

#define MAXFREQ 400.00    /* max allowable freq */
#define MINFREQ 40.00     /* min allowable freq */

#include <stdio.h>
#include <fcntl.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

#ifdef __STDC__
int logscale(short,int,int);
#else
int logscale();
#endif

#ifdef __STDC__
int    digitemFX(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,short  *buff,double  start,double  stop,int  flags)
#else
int digitemFX(bundles,xl,yb,xr,yt,item,buff,start,stop,flags)
int32                bundles;      /* colours for graph */
float              xl,yb,xr,yt;  /* co-ords of box */
struct item_header *item;        /* data definition */
short              *buff;        /* data buffer */
double             start,stop;   /* start and stop times */
int		   flags;	 /* possible options on display */
#endif
{
	register int	i;       	/* frame number */
	int	 	x,y,oldx,oldy;	/* pixel co-ords */
	int      	numf,bstart;	/* number of frames */
	int		adj;		/* offset adjustment */
	double		scalex;

	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,start,stop,flags);
	xl += digitab.ixoff/digdata.xscale;
	yt = yval(digitab.iyt);

	/* write axis label */
	y = (digitab.iyt + digitab.iyb - digdata.chheight)/2;
	digtextp(digitab.lbun,digitab.ixl+3,y,"Hz");

	/* check timing of data set */
	bstart = (start-item->offset)/item->frameduration;
	numf = 1 + (stop - start)/item->frameduration;
	if ((bstart+numf) > item->numframes) {
		/* data does not reach to right hand side */
		xr = xl + (item->numframes-bstart)*item->frameduration*digitab.scalex;
		numf = item->numframes - bstart;
	}
	if (bstart < 0) {
		/* data does not reach to left hand end */
		xl += (-bstart*item->frameduration)*digitab.scalex;
		numf += bstart;
		bstart=0;
	}

	/* draw y-axis */
	if (!(flags & DIGITEMFIX)) {
		digitab.lo = MINFREQ;
		digitab.hi = MAXFREQ;
	}
	digitemfreq(bundles,digitab.iyb,digitab.iyt,digitab.lo,digitab.hi,1);

	/* display, if anything left */
	if ((numf>0) && (bstart<item->numframes)) {

		/* get scale factors */
		scalex = item->frameduration*digitab.scalex*digdata.xscale;
		digitab.scaley = ((float)(digitab.iyt-digitab.iyb))/(digitab.hi-digitab.lo);
		adj=digitab.ixl+digitab.ixoff+(item->offset+bstart*item->frameduration-start)*digitab.scalex*digdata.xscale;

		/* draw graph */
		digclippush();
		digclip(xl,yb,xr,yt);
		if (bstart > 0) {
			oldx= adj - scalex;
			oldy=digitab.iyb+(buff[bstart-1]-digitab.lo)*digitab.scaley;
		}
		else {
			oldx = 0;
			oldy = digitab.iyb+(buff[bstart]-digitab.lo)*digitab.scaley;
		}
		for (i=0;i<numf;i++) {
			x = adj + (float)i*scalex;
			y = digitab.iyb+(buff[bstart+i]-digitab.lo)*digitab.scaley;
			if ((oldy>digitab.iyb) && (y>digitab.iyb))
				diglinep(digitab.gbun,oldx,oldy,x,y);
			oldx=x;
			oldy=y;
		}
		if ((bstart+numf) < item->numframes) {
			x = adj + (float)i*scalex;
			y = digitab.iyb+(buff[bstart+i]-digitab.lo)*digitab.scaley;
			if ((oldy>digitab.iyb) && (y>digitab.iyb))
				diglinep(digitab.gbun,oldx,oldy,x,y);
		}
		digclippop();
	}

	/* draw title if required */
	digititle(item,flags);

	/* that's it */
	digflush();
	return(0);

}

/* first attempt at log scaling */
int logscale (fxvalue,height,top)
short    fxvalue;        /* frequency */
int      height,top;     /* range and upper limit of   */
                         /* pixels in freq domain      */
{
     int   logvalue;     /* value in logscale */
     double log();

     /* return a value of 0 if FX value is <= 0, otherwise */
     /* find logvalue and return logscale value            */
    
     logvalue = (fxvalue <= 0) ? 0: (int)(height*(log(fxvalue*1.0)-
                log(digitab.lo))/(log(digitab.hi)-log(digitab.lo)));
     return (top-height+logvalue);
}


#ifdef EMO
char       *progname="digitemFX";
main(argc,argv)
int	argc;
char	*argv[];
{
	struct	item_header item;
	short	*buff;
	double	totime;

	if (strcmp(argv[1],"-p")==0) {
		digstart('k',NULL,1);
		getitem(argv[2],FX_TYPE,"*",&item,&buff);
	}
	else {
		digstart('\0',NULL,1);
		getitem(argv[1],FX_TYPE,"*",&item,&buff);
	}

	digscale(10.0,10.0,0);
	digclearscreen();

	totime = item.numframes*item.frameduration;
	digitemtime(23,0.0,9.0,10.0,9.5,0.0,totime,1);
	digitemFX(20,0.0,7.0,10.0,9.0,&item,buff,0.0,totime,1);

	digitemtime(23,0.0,6.0,10.0,6.5,totime-0.25,totime+0.25,1);
	digitemFX(20,0.0,4.0,10.0,6.0,&item,buff,totime-0.25,totime+0.25,3);

	digitemtime(23,0.0,3.0,10.0,3.5,0.0,0.5,1);
	item.offset=0.1;
	digitemFX(20,0.0,1.0,10.0,3.0,&item,buff,0.0,0.5,3);

	digend();
	exit(0);
}
#endif
