/* digitemTR -- track item display */

/* version 1.0 - M.A. Huckvale - November 1987 */

#include <stdio.h>
#include <fcntl.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

#ifdef __STDC__
int    digitemTR(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,float *buff,double  start,double   stop,int  flags)
#else
int digitemTR(bundles,xl,yb,xr,yt,item,buff,start,stop,flags)
int32		bundles;
float		xl,yb,xr,yt;
struct item_header *item;
float		*buff;
double		start,stop;
int		flags;
#endif
{
	register int	i;
	float		hi,lo;
	register float	*f;
	int		bmark,tmark;
	int		x,y,oldx,oldy;
	int		adj;
	int		numf,bstart;
	float		digtextlen();
	double		scalex;

	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,start,stop,flags);
	xl += digitab.ixoff/digdata.xscale;
	yt = yval(digitab.iyt);

	/* write axis label */
	y = (digitab.iyt + digitab.iyb - digdata.chheight)/2;
	digtextp(digitab.lbun,digitab.ixl+3,y,"Val");

	/* calculate y-coordinates for TR graph */
	bmark = digitab.iyb+1;
	tmark = digitab.iyt;
	
	/* check timing of data set */
	bstart = (start-item->offset)/item->frameduration;
	numf = 1 + (stop - start)/item->frameduration;
	if ((bstart+numf) > item->numframes) {
		/* data does not reach to right hand side */
		xr = xl + (item->numframes-bstart)*item->frameduration*digitab.scalex;
		numf = item->numframes - bstart;
	}
	if (bstart < 0) {
		/* data does not reach to left hand end */
		xl += (-bstart*item->frameduration)*digitab.scalex;
		numf += bstart;
		bstart=0;
	}

	/* display, if anything left */
	if ((numf>0) && (bstart<item->numframes)) {

		/* get max and min values */
		if (!(flags & DIGITEMFIX)) {
			f = &buff[bstart];
			lo = *f;
			hi = lo;
			for (i=0;i<numf;i++,f++) {
				if (*f < lo) lo = *f;
				if (*f > hi) hi = *f;
			}
			if (hi==lo) hi=lo+1;
			digitab.hi=hi;
			digitab.lo=lo;
		}

		/* plot y-axis */
		digitemfreq(bundles,bmark,tmark,digitab.lo,digitab.hi,0);

		/* get scale factors */
		scalex = item->frameduration*digitab.scalex*digdata.xscale;
		digitab.scaley = ((float)(tmark-bmark))/(digitab.hi-digitab.lo);
		adj=digitab.ixl+digitab.ixoff+(item->offset+bstart*item->frameduration-start)*digitab.scalex*digdata.xscale;

		/* draw graph */
		digclippush();
		digclip(xl,yb,xr,yt);
		if (bstart > 0) {
			oldx= adj - scalex;
			oldy=bmark+(buff[bstart-1]-digitab.lo)*digitab.scaley;
		}
		else {
			oldx = 0;
			oldy = bmark+(buff[bstart]-digitab.lo)*digitab.scaley;
		}
		for (i=0;i<numf;i++) {
			x = adj + (float)i*scalex;
			y = bmark+(buff[bstart+i]-digitab.lo)*digitab.scaley;
			if (flags & DIGITEMTOPHAT) {
				diglinep(digitab.gbun,oldx,oldy,x,oldy);
				diglinep(digitab.gbun,x,oldy,x,y);
			}
			else
				diglinep(digitab.gbun,oldx,oldy,x,y);
			oldx=x;
			oldy=y;
		}
		if ((bstart+numf) < item->numframes) {
			x = adj + (float)i*scalex;
			y = bmark+(buff[bstart+i]-digitab.lo)*digitab.scaley;
			if (flags & DIGITEMTOPHAT) {
				diglinep(digitab.gbun,oldx,oldy,x,oldy);
				diglinep(digitab.gbun,x,oldy,x,y);
			}
			else
				diglinep(digitab.gbun,oldx,oldy,x,y);
		}
		digclippop();
	}

	/* draw title if required */
	digititle(item,flags);

	/* that's it */
	digflush();
	return(0);
}

#ifdef EMO
char	*progname="digitemTR";
main(argc,argv)
int	argc;
char	*argv[];
{
	struct	item_header item;
	short	*buff;
	double	totime;

	if (strcmp(argv[1],"-p")==0) {
		digstart('k',NULL,1);
		getitem(argv[2],TR_TYPE,"*",&item,&buff);
	}
	else {
		digstart('\0',NULL,1);
		getitem(argv[1],TR_TYPE,"*",&item,&buff);
	}

	digscale(10.0,10.0,0);
	digclearscreen();

	totime = item.numframes*item.frameduration;
	digitemtime(23,0.0,9.0,10.0,9.5,0.0,totime,1);
	digitemTR(20,0.0,7.0,10.0,9.0,&item,buff,0.0,totime,1);

	digitemtime(23,0.0,6.0,10.0,6.5,totime-0.25,totime+0.25,1);
	digitemTR(20,0.0,4.0,10.0,6.0,&item,buff,totime-0.25,totime+0.25,3);

	digitemtime(23,0.0,3.0,10.0,3.5,0.0,0.1,1);
	item.offset=0.05;
	digitemTR(20,0.0,1.0,10.0,3.0,&item,buff,0.0,0.1,3);

	digend();
	exit(0);
}
#endif
