/*  digitemVU -- Voice/Unvoice item display  */

/* version 1.0 - January 1991 */

#include <stdio.h>
#include <fcntl.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

#ifdef __STDC__
int    digitemVU(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,struct vu_rec *buff,double  start,double   stop,int  flags)
#else
int digitemVU(bundles,xl,yb,xr,yt,item,buff,start,stop,flags)
int32		bundles;	/* colours for graph */
float		xl,yb,xr,yt;	/* co-ords of box */
struct item_header *item;	/* data definition */
struct vu_rec	*buff;		/* data buffer */
double		start,stop;     /* start and stop times	*/
int	 	flags;		/* possible options on display */
#endif
{
	register int	i;
	int		x,y;
	int		lastx;
	int		bmark,tmark;
	int		lvoice=0;
	double		time;

	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,start,stop,flags);
	xl += digitab.ixoff/digdata.xscale;

	/* write axis label */
	y = (digitab.iyt + digitab.iyb - digdata.chheight)/2;
	digtextp(digitab.lbun,digitab.ixl+3,y,"VU");

	/* calc line positions */
	bmark = digitab.iyb+1;
	tmark = digitab.iyt;

	/* draw graph */
	i=0;
	time=buff[i].posn*item->frameduration+item->offset;
	lastx = digitab.ixl + digitab.ixoff;
	while ((i<item->numframes) && (time<stop)) {
		if (time >= start) {
 			x = digitab.ixl+digitab.ixoff + (time-start) * digitab.scalex * digdata.xscale;
			if (buff[i].flag != lvoice)
				diglinep(digitab.gbun,x,bmark,x,tmark);
			if (lvoice)
				diglinep(digitab.gbun,lastx,(tmark+bmark)/2,x,(tmark+bmark)/2);
			lastx = x;
		}
		lvoice = buff[i].flag;
		i++;
		time=buff[i].posn*item->frameduration+item->offset;		
	}
	if (lvoice) {
		time=(buff[i].posn+buff[i].size)*item->frameduration+item->offset;		
		x = digitab.ixl+digitab.ixoff + (time-start) * digitab.scalex * digdata.xscale;
		if (x > digitab.ixr) 
			x = digitab.ixr;
		else
			diglinep(digitab.gbun,x,bmark,x,tmark);
		diglinep(digitab.gbun,lastx,(tmark+bmark)/2,x,(tmark+bmark)/2);
	}

	/* draw title if required */
	digititle(item,flags);

	/* that's it */
	digflush();
	return(0);
}

#ifdef	EMO
char	*progname="digitemVU";
main(argc,argv)
int	argc;
char	*argv[];
{
	struct		item_header item;          /* data definition */
	struct vu_rec	*buff;                     /* data buffer     */

	/* choose between laser printer or terminal, 'k' indicates   */
	/* the laser printer, '\0' indicates a terminal.                */

	if (strcmp(argv[1],"-p") ==0) { 
		digstart ('k',NULL,1);
	  	getitem(argv[2],VU_TYPE,"*",&item,&buff);
	}
	else { 
		digstart ('\0',NULL,1);
		getitem(argv[1],VU_TYPE,"*",&item,&buff);
	}

	/* set the scale */
	digscale (10.0,10.0,0);
	
	/* clear the screen for the display */
	digclearscreen();

	/* call digitemtime for the timescale */
	digitemtime(23,0.0,9.0,10.0,9.5,0.0,1.0,1);

	/* call digitemVU for the VU data */
	digitemVU(20,0.0,6.0,10.0,9.0,&item,buff,0.0,1.0,1);

	digitemVU(20,0.0,3.0,10.0,6.0,&item,buff,0.5,1.5,3);

	item.offset=0.1;
	digitemVU(20,0.0,0.0,10.0,3.0,&item,buff,0.0,1.0,3);

	digend();
	exit(0);
}
#endif

		
