/* netaccess - network version of access and stat call */

/* global declarations */
#include "SFSCONFG.h"
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include "sfs.h"

/* check if only replacement "stub" routine required */
#ifndef NETWORK

/* replacement network file access */
void netaccess(node,filename,size,date)
char	*node;
char	*filename;
int32	*size,*date;
{
	*size=0;
	*date=0;
	return;
}

#else

/* network file access routine */
#include "sfsnet.h"

/* global data */
static struct sockaddr_in sinhim = { AF_INET };
extern int errno;
struct reqrec request;

/* network file access check */
void netaccess(node,filename,size,date)
char	*node;
char	*filename;
int32	*size,*date;
{
	/* processing variable */
	int		rlen;			/* request length */
	short		status;			/* request status */
	short		mode;			/* file mode */
	int		fd;			/* socket descriptor */
	int		ofd;			/* output file descriptor */
	struct hostent 	*hp;			/* host name pointer */

	/* get node address */
	hp = gethostbyname(node);
	if (!hp)
		error("'%s' host not found",node);

	/* get a socket */
	bcopy(hp->h_addr, &sinhim.sin_addr, sizeof(sinhim.sin_addr));
	sinhim.sin_port = htons(PORTNUM);
	if ((fd=socket(AF_INET, SOCK_STREAM, 0)) < 0)
		error("unable to open socket",NULL);

	/* make connection */
	if (connect(fd,&sinhim,sizeof(sinhim)) < 0)
		error("unable to connect socket",NULL);

	/* send request */
	request.reqid = htons(FILESTAT);
	strcpy(request.buff,filename);
	rlen = sizeof(request)-sizeof(request.buff)+strlen(request.buff)+1;
	if (write(fd,&request,rlen) != rlen)
		error("write error on stream",NULL);

	/* wait for reply */
	if ((rlen=read(fd,&request,sizeof(request))) < 2*sizeof(short))
		error("read error on stream",NULL);

	/* close channel */
	close(fd);

	/* check information */
	status = (short)ntohs(request.status);
	mode = ntohs(request.mode);
	if (status < 0) {
		if (status==-2)
			error("%s: Network device not ready\n",filename);
		else
			error("%s: Network file does not exist\n",filename);
	}
	else {
		if (!(mode & S_IFREG))
			error("%s: Network file is not regular file\n",filename);
		*size = ntohl(request.length);
		*date = ntohl(request.start);
	}

	/* that's all folks */
	return;
}
#endif
