/* sfsconvi -- convert item header formats */

/* version 1.0 - june 1987 */

#include "SFSCONFG.h"
#include <stdio.h>
#include "sfs.h"

/* macros to reverse ints and floats */
#define REVERSE4(x)	p = (unsigned char *)&x; \
			t = *p; *p = *(p+3); *(p+3) = t; \
			t = *++p; *p = *(p+1); *(p+1) = t;
#define REVERSE8(x)	p = (unsigned char *)&x; \
			t = *p; *p = *(p+7); *(p+7) = t; \
			t = *++p; *p = *(p+5); *(p+5) = t; \
			t = *++p; *p = *(p+3); *(p+3) = t; \
			t = *++p; *p = *(p+1); *(p+1) = t;

void sfsconvi(item)
struct item_header 	*item;
{
	register unsigned char	*p,t;

	/* convert 8086 to 68000 */
	if (((item->machine & 0xFF)==1) && (SFSMACHINE==0)) {
		REVERSE4(item->processdate);
		item->processdate -= 28800;
		REVERSE4(item->datatype);
		REVERSE4(item->subtype);
		REVERSE4(item->floating);
		REVERSE4(item->datasize);
		REVERSE4(item->framesize);
		REVERSE4(item->numframes);
		REVERSE4(item->length);
		REVERSE4(item->datapresent);
		REVERSE4(item->windowsize);
		REVERSE4(item->overlap);
		REVERSE4(item->lxsync);
		REVERSE8(item->frameduration);
		REVERSE8(item->offset);
	}
	else if (((item->machine & 0xFF)==0) && ((SFSMACHINE & 0xFF)==1)) {
		REVERSE4(item->processdate);
		item->processdate += 28800;
		REVERSE4(item->datatype);
		REVERSE4(item->subtype);
		REVERSE4(item->floating);
		REVERSE4(item->datasize);
		REVERSE4(item->framesize);
		REVERSE4(item->numframes);
		REVERSE4(item->length);
		REVERSE4(item->datapresent);
		REVERSE4(item->windowsize);
		REVERSE4(item->overlap);
		REVERSE4(item->lxsync);
		REVERSE8(item->frameduration);
		REVERSE8(item->offset);
	}
}
