/* video -- terminal-independent text enhancement commands */

/*--------------------------------------------------------------------------*/
/**MAN
.TH VIDEO SFS3 UCL SFS
.SH NAME
video - terminal-independent text enhancement routines
.SH SYNOPSIS
.nf

initvideo(flag);
int    flag;

italicon();
italicoff();
boldon();
boldoff();
uparrow();

.fi
.SH DESCRIPTION
.I initvideo()
is an optional routine that may be used to enforce the generation of terminal codes
even if the process is not connected to a terminal.  If 
.I flag
is set then the following routines always produce codes.  Default action is only to send
codes if the process is talking to a terminal, in which case this routine need not be called.
.I italicon()
sends appropriate codes to the terminal to turn italics (or underlining) on.
.I italicoff()
sends appropriate codes to the terminal to turn italics (or underlining) off.
.I boldon()
sends appropriate codes to the terminal to turn bold (or reverse video) on.
.I boldoff()
sends appropriate codes to the terminal to turn bold (or reverse video) off.
.I uparrow()
sends appropriate codes to the terminal to move the cursor up one line.
.SH VERSION/AUTHOR
1.0 - Mark Huvkvale.
.SH SEE ALSO
termcap(3)
*/
/*--------------------------------------------------------------------------*/

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"

/* text formatting data */
#ifndef DOS
static char	termcap[1024];		/* termcap entry for terminal */
static char	termfunc[1024];		/* terminal function strings */
static int	vidinit=0;
static char	*so,*se;		/* strings for standout on/standout end */
static char	*us,*ue;		/* strings for underline on/underline off */
static char	*up;			/* string for up cursor */
#endif

void initvideo(flag)
int	flag;		/* 0=std, 1=force output */
{
#ifndef DOS
	char	*ptr;
	if (flag || isatty(1)) {
		if (tgetent(termcap,getenv("TERM")) == 1) {
			ptr=termfunc;
			so=ptr;
			tgetstr("so",&ptr);
			se=ptr;
			tgetstr("se",&ptr);
			us=ptr;
			tgetstr("us",&ptr);
			ue=ptr;
			tgetstr("ue",&ptr);
			up=ptr;
			tgetstr("up",&ptr);
			vidinit++;
		}
	}
#endif
}

#ifdef DOS
void boldon()
{
	fputs("\033[7m",stdout);
}
void boldoff()
{
	fputs("\033[0m",stdout);
}
void italicon()
{
	fputs("\033[1m",stdout);
}
void italicoff()
{
	fputs("\033[0m",stdout);
}
void uparrow()
{
	fputs("\033[A",stdout);
}
#else
static void vidout(c)
char	c;
{
	putchar(c);
}

void boldon()
{
	if (!vidinit) initvideo(0);
	tputs(so,1,vidout);
}
void boldoff()
{
	if (!vidinit) initvideo(0);
	tputs(se,1,vidout);
}
void italicon()
{
	if (!vidinit) initvideo(0);
	tputs(us,1,vidout);
}
void italicoff()
{
	if (!vidinit) initvideo(0);
	tputs(ue,1,vidout);
}
void uparrow()
{
	if (!vidinit) initvideo(0);
	printf("%s",up);
}
#endif

#ifdef IAG
main()
{
	int	i;

	printf("TEST VIDEO ATTRIBUTES\n");

	italicon();
	printf("\tItalic\n");
	italicoff();
	boldon();
	printf("\tBold\n");
	italicon();
	printf("\tItalic Bold\n");
	boldoff();
	italicoff();
	printf("\tNormal\n");
	for (i=0;i<5;i++) {
		uparrow();
		boldon();
		printf("\tNormal\n");
		boldoff();
		sleep(1);
		uparrow();
		printf("\tNormal\n");
		sleep(1);
	}
	exit(0);
}
#endif
