/* esmenu -- standard interactive menus */

/* M.A.Huckvale - University College London */

/* version 1.0 - August 1993
	- from Esmouse.c
*/

/*-------------------------------------------------------------------------*/
/**MAN
.TH ESMENU SFS3 UCL
.SH NAME
.B esmenu
- standard interactive menus
.SH SYNOPSIS
.nf
esmenu_display(bundle,labels,keys,cnt)
int bundle;
char *labels[];
char *keys[];
int cnt;

esmenu_redisplay()

int esmenu_check(xmouse,ymouse,key)
float xmouse,ymouse;
int key;

int esmenu_checkp(ixmouse,iymouse,key)
int ixmouse,iymouse;
int key;
.fi
.SH DESCRIPTION
.B esmenu
provides a simple standard mechanism for offering interactive menus.
esmenu_display() displays a list of menu items that can be selected by
mouse click or by key press.  A list of short text labels is used to
create and display a set of buttons on the screen, the positions of
the buttons on the screen are stored internally, as are a list of
permissable key alterantives.  The routine esmenu_check() checks
to see if a mouse pointer or a key press has selected one of the boxes
which is then highlighted.  The routine esmenu_checkp() gives the same
function but with pixel co-ordinates.  The routine esmenu_redisplay()
redisplays the current menu with all selections cancelled.
.SH VERSION/AUTHOR
.IP 1.0
Mark Huckvale
*/
/*--------------------------------------------------------------------------*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <malloc.h>
#include <ctype.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "es.h"

#define MAXMENU	32
struct item_rec {
	int	xl,yb,xr,yt;	/* button co-ordinates */
	char	*label;		/* text label */
	char	*keys;		/* accelerator keys */
};
static struct item_rec itemtab[MAXMENU];
static int	itemcnt;
static int	bundle;

static char *strsave(str)
char *str;
{
	char *p;
	if (str) {
		p = malloc(strlen(str)+1);
		strcpy(p,str);
		return(p);
	}
	else
		return(NULL);
}

void esmenu_display(bun,lab,key,cnt)
int	bun;
char	*lab[];
char	*key[];
int	cnt;
{
	int	i;
	int	max;

	bundle = bun;

	/* truncate ambition */
	if (cnt > MAXMENU)
		itemcnt=MAXMENU;
	else
		itemcnt = cnt;

	/* initialise internal structures */
	max = 0;
	for (i=0;i<itemcnt;i++) {
		if (itemtab[i].label) free(itemtab[i].label);
		itemtab[i].label=strsave(lab[i]);
		if (strlen(lab[i]) > max) max = strlen(lab[i]);
		if (itemtab[i].keys) free(itemtab[i].keys);
		itemtab[i].keys=strsave(key[i]);
	}
	
	/* calculate positions */
	itemtab[0].yt = digdata.nvert-1;
	itemtab[0].xr = digdata.nhoriz-1;
	itemtab[0].yb = digdata.nvert - 2*digdata.chheight;
	itemtab[0].xl = itemtab[0].xr - (max+2)*digdata.chwidth;
	for (i=1;i<itemcnt;i++) {
		itemtab[i].yt = itemtab[i-1].yt;
		itemtab[i].xr = itemtab[i-1].xl;
		itemtab[i].yb = itemtab[i-1].yb;
		itemtab[i].xl = itemtab[i].xr - (max+2)*digdata.chwidth;
	}

	/* display */
	esmenu_redisplay();
}

/* display mouse buttons */
void esmenu_redisplay()
{
	int	i;
	int	oldmode;

	digflush();
	oldmode = diglinemode(0);
	for (i=0;i<itemcnt;i++) {
		digfillboxp((digdata.device=='s')?0:bundle,itemtab[i].xl,itemtab[i].yb,
			itemtab[i].xr,itemtab[i].yt);
	 	digtextp(24,(itemtab[i].xl+itemtab[i].xr-strlen(itemtab[i].label)*digdata.chwidth)/2,
			itemtab[i].yb+digdata.chheight/2,itemtab[i].label);
		digboxp(24,itemtab[i].xl,itemtab[i].yb,
			itemtab[i].xr,itemtab[i].yt);
	}
	digflush();
	diglinemode(oldmode);
}

/* check if item selected */
static void selectbox(bnum)
int	bnum;
{
	int	oldmode;
	digflush();
	oldmode=diglinemode(0);
	digfillboxp(0,itemtab[bnum].xl,itemtab[bnum].yb,
		itemtab[bnum].xr,itemtab[bnum].yt);
 	digtextp(24,(itemtab[bnum].xl+itemtab[bnum].xr-strlen(itemtab[bnum].label)*digdata.chwidth)/2,
		itemtab[bnum].yb+digdata.chheight/2,itemtab[bnum].label);
	digboxp(24,itemtab[bnum].xl,itemtab[bnum].yb,
		itemtab[bnum].xr,itemtab[bnum].yt);
	digflush();
	diglinemode(oldmode);
}

#ifdef __STDC__
int esmenu_check(float xm,float ym,int ky)
#else
int esmenu_check(xm,ym,ky)
float	xm,ym;
int	ky;
#endif
{
	return(esmouse_checkp(xpix(xm),ypix(ym),ky));
}

int esmouse_checkp(ixm,iym,ky)
int	ixm,iym;
int	ky;
{
	int	i;

	if (ky>=0) {
		for (i=0;i<itemcnt;i++) if (itemtab[i].keys)
			if (strchr(itemtab[i].keys,ky)) {			
			    	selectbox(i);
				return(i);
			}
	}
	else for (i=0;i<itemcnt;i++)
		if ((ixm > itemtab[i].xl) &&
		    (ixm <= itemtab[i].xr) &&
		    (iym > itemtab[i].yb) &&
		    (iym <= itemtab[i].yt)) {
		    	selectbox(i);
		    	return(i);
		    }
	return(-1);
}

#ifdef EMO
char *progname="esmenu";

char *lab1[4]={"zero","one","two","three"};
char *key1[4]={"0zZ","1oO","2tT","3hH"};

main()
{
	float	mousex,mousey;
	int	button,obutton=0;
	int	ch;
	int	com;
	char	messg[80];
	
	digstart(DIG_DEFAULT_TERM,NULL,1);

	esmenu_display(lab1,key1,4);

	diginitmouse(0.5,0.5);

	do {
		esmenu_redisplay();

		/* get new button press */
		do {
			do {
				ch=diggetmousech(&button,&mousex,&mousey);
			} while ((ch==DIG_MOUSE) && (button==obutton));

			obutton=button;

		} while ((ch <= 0) && (button == 0));

		/* process command */
		com = esmenu_check(mousex,mousey,ch);
		if (com >= 0) {
			digfillbox(0,0.4,0.4,0.6,0.6);
			sprintf(messg,"BOX%02d BTN%d",com,button);
			digboxtext(24,0.5,0.4,0.2,0.2,0.0,messg,1);
		}
	} while (ch!='q');
	digkillmouse();
	digend();
	exit(0);
}
#endif
