/* Esmouse -- generic mouse routine for Es and digitem displays */

/* demonstration enhancements - define DEMO */
#undef DEMO

#include "SFSCONFG.h"
#include <stdio.h>		/* standard i-o routines */
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <digdata.h>
#include <ctype.h>
#include <math.h>
#include "dig.h"
#include "digitem.h"
#include "sfs.h"
#include "es.h"
extern char	*sfslabel[];

float	mousex=0.5,mousey=0.5;

/* menus */
#define MENUNUM	2
#define MENUCNT	6
int	menu_count[MENUNUM]={6,5};
int	menu_bundle[MENUNUM]={21,19};
char	*menu_names[MENUNUM][MENUCNT]={
	{ "quit",		"file",		"play",		"move",		"zoom",		"anno" },
	{ "main",		"hard",		"tree",		"copy",		"link",		""}
};
char	*menu_keys[MENUNUM][MENUCNT]={
/* menu 0 */
	{ "QqXx\033\003",	"Ff",		"PpOo[{+",	"LlRrUuTt",	"ZzCcGg",	"AaBb" },
/* menu 1 */
	{ "QqXx\033\003Mm\n\r","HhPp",	"Tt",		"Cc",		"Ll",		"" }
};
struct menu_map_rec {
	struct {
		char	lett;
		int	mask,comm;
	} command[4];
} menu_map[MENUNUM][MENUCNT]={
#ifdef __STDC__
{ /* menu 0 */
	{ '\0',7,ES_QUIT,	'\0',0,0,		'\0',0,0,		'\0',0,0 },
	{ '\0',7,ES_FILEMENU,	'\0',0,0,		'\0',0,0,		'\0',0,0 },
	{ 'p',4,ES_PLAY_ALL,	'o',2,ES_PLAY_LEFT,	'[',1,ES_PLAY_RIGHT,	'+',4,ES_PLAY_ALL },
	{ 'l' ,4,ES_LEFT,	'u',2,ES_UP,		'r',1,ES_RIGHT,		't',7,ES_TOP },
	{ 'z',7,ES_DOWN,	'g',7,ES_GOTO,		'\0',0,0,		'\0',0,0 },
	{ 'a',7,ES_ANNOT,	'b',7,ES_ANNOT_RIGHT,	'\0',0,0,		'\0',0,0 }, 
},
{ /* menu 1 */
	{ '\0',7,ES_MAINMENU,	'\0',0,0,		'\0',0,0,		'\0',0,0 },
	{ '\0',7,ES_PRINT,	'\0',0,0,		'\0',0,0,		'\0',0,0 },
	{ '\0',7,ES_TREE,	'\0',0,0,		'\0',0,0,		'\0',0,0 },
	{ '\0',7,ES_COPY,	'\0',0,0,		'\0',0,0,		'\0',0,0 },
	{ '\0',7,ES_LINK,	'\0',0,0,		'\0',0,0,		'\0',0,0 },
	{ '\0',0,0,		'\0',0,0,		'\0',0,0,		'\0',0,0 },
}
#else
/* menu 0 */
	 '\0',7,ES_QUIT,	'\0',0,0,		'\0',0,0,		'\0',0,0 ,
	 '\0',7,ES_FILEMENU,	'\0',0,0,		'\0',0,0,		'\0',0,0 ,
	 'p',4,ES_PLAY_ALL,	'o',2,ES_PLAY_LEFT,	'[',1,ES_PLAY_RIGHT,	'+',4,ES_PLAY_ALL ,
	 'l' ,4,ES_LEFT,	'u',2,ES_UP,		'r',1,ES_RIGHT,		't',7,ES_TOP ,
	 'z',7,ES_DOWN,		'g',7,ES_GOTO,		'\0',0,0,		'\0',0,0 ,
	 'a',7,ES_ANNOT,	'b',7,ES_ANNOT_RIGHT,	'\0',0,0,		'\0',0,0 , 
/* menu 1 */
	 '\0',7,ES_MAINMENU,	'\0',0,0,		'\0',0,0,		'\0',0,0 ,
	 '\0',7,ES_PRINT,	'\0',0,0,		'\0',0,0,		'\0',0,0 ,
	 '\0',7,ES_TREE,	'\0',0,0,		'\0',0,0,		'\0',0,0 ,
	 '\0',7,ES_COPY,	'\0',0,0,		'\0',0,0,		'\0',0,0 ,
	 '\0',7,ES_LINK,	'\0',0,0,		'\0',0,0,		'\0',0,0 ,
	 '\0',0,0,		'\0',0,0,		'\0',0,0,		'\0',0,0 ,
#endif
};

/* special (non-menu) commands */
struct special_rec {
	int	lett;
	int	comm;
} specialcomm[]={
#ifdef __STDC__
	{ '<',	ES_CURSOR_LEFT },
	{ '>',	ES_CURSOR_RIGHT },
	{ '\r',	ES_ACTION },
#else
	'<',	ES_CURSOR_LEFT,
	'>',	ES_CURSOR_RIGHT,
	'\r',	ES_ACTION,
#endif
};
#define NUMSPECIALCOMM (sizeof(specialcomm)/sizeof(struct special_rec))

extern int labelmode;
extern int domeasure;
int	ansel = -1;		/* annotation selected in label mode */
double	anstart;

#ifdef __STDC__
int digitmouse(int bundles,float xl,float yb,float xr,float yt,double *start,double *stop)
#else
int digitmouse(bundles,xl,yb,xr,yt,start,stop)
int	bundles;
float	xl,yb,xr,yt;
double	*start,*stop;
#endif
{
	int	comm=ES_NULL;
	float	left,right;
	static int button,obutton;
	double	newstart,newstop;
	float	tsize;
	int	ch;
	char	messg[128];
	char	inpline[80];
	int	inptr=0;
	int	inload=0;
	int	curmen=0;	/* current menu */
	int	parload=0;
	int	parcom=0;

	/* sort out bundles */
	digitbundle(bundles);

	/* get pixel coordinates of original box */
	digitab.ixl = xpix(xl);
	digitab.iyb = ypix(yb);
	digitab.ixr = xpix(xr);
	digitab.iyt = ypix(yt);

	/* determine size of x-axis offset */
	digitab.ixoff = AXCHAR * digdata.chwidth + 3;
	xl += digitab.ixoff/digdata.xscale;
	tsize = 2 * digdata.chheight / digdata.yscale;
	yt -= 2*tsize;
	yb += tsize;

	/* get scale factor */
	digitab.scalex = (xr-xl)/(*stop - *start);

	/* draw mouse boxes */
	curmen=0;
	esmenu_display(menu_bundle[curmen],menu_names[curmen],menu_keys[curmen],
		((curmen==0) && (labelmode==0))?menu_count[curmen]-1:menu_count[curmen]);

	/* initmouse */
	diginitmouse(mousex,mousey);
	diglinemode(1);
	left = -1;
	right= -1;
	newstart = *start;
	newstop = *stop;
	ansel = -1;

	/* process mouse */
	do {
		/* get new button press */
		do {
			do {
				ch=diggetmousech(&button,&mousex,&mousey);
			} while ((ch==DIG_MOUSE) && (button==obutton));

			obutton=button;

		} while ((ch==DIG_MOUSE) && (button == 0));

		/* check for special mouse commands */
		if (ch==DIG_QUIT) {
			newstart = *start;
			newstop = *stop;
			comm=ES_QUIT;
			goto fastexit;
		}
		else if (ch==DIG_REDRAW) {
			newstart = *start;
			newstop = *stop;
			comm=ES_REPAINT;
			goto fastexit;
		}

		/* decode button press in graph area */
		if (button && (mousex >= xl) && (mousex <= xr) &&
		    (mousey >= yb) && (mousey <= yt)) {
			/* process screen command */
			switch (button) {
			case 4:		/* left button */
				if (left > 0) { digline(digitab.lbun,left,yb,left,yt); digflush(); }
				if (left == mousex) {
					left = -1;
					newstart = *start;
				}
				else {
					digline(digitab.lbun,mousex,yb,mousex,yt);
					digflush();
					left=mousex;
					newstart = *start + (left-xl)/digitab.scalex;
				}
				if (labelmode && (ansel >= 0)) {
					if (left > 0) { digline(digitab.lbun,left,yb,left,yt); digflush(); }
					if (right > 0) { digline(digitab.lbun,right,yb,right,yt); digflush(); }
					diglinemode(0);
					movan(ansel,newstart,*start,*stop);
					ansel = -1;
					diglinemode(1);
					if (left > 0) { digline(digitab.lbun,left,yb,left,yt); digflush(); }
					if (right > 0) { digline(digitab.lbun,right,yb,right,yt); digflush(); }
				}
				break;
			case 2:		/* middle button */
				ansel = -1;
#ifdef DEMO
				if (labelmode) {
					if ((left >= 0) && (mousex < left)) {
						invbox(mousey,xl,left);
						repspeech(mousey,*start,*stop,*start,newstart);
						invbox(mousey,xl,left);
					}
					else if ((right >= 0) && (mousex > right)) {
						invbox(mousey,right,xr);
						repspeech(mousey,*start,*stop,newstop,*stop);
						invbox(mousey,right,xr);
					}
					else {
						invbox(mousey,(left >= 0)?left:xl,(right>=0)?right:xr);
						repspeech(mousey,*start,*stop,newstart,newstop);
						invbox(mousey,(left >= 0)?left:xl,(right>=0)?right:xr);
					}
				} 
				else if (newstart < newstop) {
					invbox(mousey,(left >= 0)?left:xl,(right>=0)?right:xr);
					repspeech(mousey,*start,*stop,newstart,newstop);
					invbox(mousey,(left >= 0)?left:xl,(right>=0)?right:xr);
				}
				else {
					invbox(mousey,(left >= 0)?left:xl,(right>=0)?right:xr);
					repspeech(mousey,*start,*stop,newstop,newstart);
					invbox(mousey,(left >= 0)?left:xl,(right>=0)?right:xr);
				}
#else
				if (labelmode) {
					if ((mousey > yb) && (mousey < yb+3*tsize))
						ansel=selan(*start + (mousex-xl)/digitab.scalex,*start,*stop);
					else if ((left >= 0) && (mousex < left))
						repspeech(mousey,*start,*stop,*start,newstart);
					else if ((right >= 0) && (mousex > right))
						repspeech(mousey,*start,*stop,newstop,*stop);
					else
						repspeech(mousey,*start,*stop,newstart,newstop);
				} 
				else if (newstart < newstop)
					repspeech(mousey,*start,*stop,newstart,newstop);
				else
					repspeech(mousey,*start,*stop,newstop,newstart);
#endif
				break;
			case 1:		/* right button */
				if (right > 0) { digline(digitab.lbun,right,yb,right,yt); digflush(); }
				if (right == mousex) {
					right = -1;
					newstop = *stop;
				}
				else {
					digline(digitab.lbun,mousex,yb,mousex,yt);
					digflush();
					right=mousex;
					newstop = *start + (right-xl)/digitab.scalex;
				}
				if (labelmode && (ansel >= 0)) {
					if (left > 0) { digline(digitab.lbun,left,yb,left,yt); digflush(); }
					if (right > 0) { digline(digitab.lbun,right,yb,right,yt); digflush(); }
					diglinemode(0);
					movan(ansel,newstop,*start,*stop);
					ansel = -1;
					diglinemode(1);
					if (left > 0) { digline(digitab.lbun,left,yb,left,yt); digflush(); }
					if (right > 0) { digline(digitab.lbun,right,yb,right,yt); digflush(); }
				}
				break;
			}
			if (domeasure) {
				double t;
				t = fabs(newstop-newstart);
				sprintf(messg,"Cursors=%.4f-%.4f (Interval %.4fs, %.1fHz), Y-value=%4g",
					newstart,newstop,t,(t==0.0)?0.0:1.0/t,findvalue(mousey));
				diglinemode(0);
				displaymeasure(messg);
				diglinemode(1);
			}
		}

		/* check for loading of annotation */
		if (labelmode && inload) {
			if ((left < 0) || (ch=='\033')) {
				/* cancel annotation */
				inload=0;
				clear_top_line();
				title_display();
				esmenu_redisplay();
			}
			else if (ch) {
				if ((ch=='\n') || (ch=='\r')) {
					/* add annotation */	
					inpline[inptr]='\0';
					if (left > 0) { digline(digitab.lbun,left,yb,left,yt); digflush(); }
					if (right > 0) { digline(digitab.lbun,right,yb,right,yt); digflush(); }
					diglinemode(0);
					addan(inpline,anstart,*start,*stop);
					inload=0;
					clear_top_line();
					title_display();
					esmenu_redisplay();
					diglinemode(1);
					if (left > 0) { digline(digitab.lbun,left,yb,left,yt); digflush(); }
					if (right > 0) { digline(digitab.lbun,right,yb,right,yt); digflush(); }
				}
				else if ((ch==0x7F) || (ch==8)) {
					/* delete char */
					if (inptr==0) {
						putchar(7);
						fflush(stdout);
					}
					else {
						inptr--;
						clear_top_line();
						inpline[inptr]='\0';
						sprintf(messg,"Annotation (ESC to cancel) : %s",inpline);
						digprompt(messg);
					}
				}
				else {
					if (inptr < 80)
						inpline[inptr++]=ch;
					else {
						putchar(7);
						fflush(stdout);
					}
					ch='\0';
					clear_top_line();
					inpline[inptr]='\0';
					sprintf(messg,"Annotation (ESC to cancel) : %s",inpline);
					digprompt(messg);
				}
			}
		}
		else if (parload) {
			if (ch=='\033') {
				/* cancel parameter */
				parload=0;
				clear_top_line();
				title_display();
				esmenu_redisplay();
			}
			else if (ch) {
				if ((ch=='\n') || (ch=='\r')) {
					parload=0;
					clear_top_line();
					if ((parcom==ES_GOTO) && (inptr > 0)) {
						newstart = atof(inpline);
						newstop = newstart + *stop - *start;
						if (newstart <= *start)
							comm = ES_LEFT;
						else
							comm = ES_RIGHT;
					}
					else {
						title_display();
						esmenu_display(menu_bundle[curmen],menu_names[curmen],menu_keys[curmen],
							((curmen==0) && (labelmode==0))?menu_count[curmen]-1:menu_count[curmen]);
					}
				}
				else if ((ch==0x7F) || (ch==8)) {
					/* delete char */
					if (inptr==0) {
						putchar(7);
						fflush(stdout);
					}
					else {
						inptr--;
						clear_top_line();
						inpline[inptr]='\0';
						sprintf(messg,"Parameter (ESC to cancel) : %s",inpline);
						digprompt(messg);
					}
				}
				else {
					if (inptr < 80)
						inpline[inptr++]=ch;
					else {
						putchar(7);
						fflush(stdout);
					}
					ch='\0';
					clear_top_line();
					inpline[inptr]='\0';
					sprintf(messg,"Parameter (ESC to cancel) : %s",inpline);
					digprompt(messg);
				}
			}
		}
		else {
			/* decode key and mouse box commands */
			comm=getboxcom(ch,button,mousex,mousey,curmen);

			if ((comm == ES_ANNOT) || (comm == ES_ANNOT_RIGHT)) {
				inload = !inload;
				/* annotation selected */
				if ((comm==ES_ANNOT) && (left < 0)) {
					/* annotation not acceptable */
					inload=0;
					esmenu_redisplay();
					putchar(7);
				}
				else if ((comm==ES_ANNOT_RIGHT) && (right < 0)) {
					/* annotation not acceptable */
					inload=0;
					esmenu_redisplay();
					putchar(7);
				}
				else {
					/* ok, go and get it */
					clear_top_line();
					sprintf(messg,"Annotation (ESC to cancel) : ");
					digprompt(messg);
					anstart = (comm==ES_ANNOT)?newstart:newstop;
					inptr=0;
				}
			}
			else if (comm == ES_FILEMENU) {
				curmen=1;
				clear_top_line();
				title_display();
				esmenu_display(menu_bundle[curmen],menu_names[curmen],menu_keys[curmen],
					((curmen==0) && (labelmode==0))?menu_count[curmen]-1:menu_count[curmen]);
			}
			else if (comm == ES_MAINMENU) {
				curmen = 0;
				clear_top_line();
				title_display();
				esmenu_display(menu_bundle[curmen],menu_names[curmen],menu_keys[curmen],
					((curmen==0) && (labelmode==0))?menu_count[curmen]-1:menu_count[curmen]);
			}
			else if (comm == ES_PLAY_ALL) {
				if (mousey > yt) mousey = yt;
				if (newstart < newstop)
					repspeech(mousey,*start,*stop,newstart,newstop);
				else
					repspeech(mousey,*start,*stop,newstop,newstart);
				esmenu_display(menu_bundle[curmen],menu_names[curmen],menu_keys[curmen],
					((curmen==0) && (labelmode==0))?menu_count[curmen]-1:menu_count[curmen]);
			}
			else if (comm == ES_PLAY_LEFT) {
				if (mousey > yt) mousey = yt;
				if (newstart < newstop) {
					repspeech(mousey,*start,*stop,*start,newstart);
				}
				else {
					repspeech(mousey,*start,*stop,*start,newstop);
				}
				esmenu_display(menu_bundle[curmen],menu_names[curmen],menu_keys[curmen],
					((curmen==0) && (labelmode==0))?menu_count[curmen]-1:menu_count[curmen]);
			}
			else if (comm == ES_PLAY_RIGHT) {
				if (mousey > yt) mousey = yt;
				if (newstart < newstop) {
					repspeech(mousey,*start,*stop,newstop,*stop);
				}
				else {
					repspeech(mousey,*start,*stop,newstart,*stop);
				}
				esmenu_display(menu_bundle[curmen],menu_names[curmen],menu_keys[curmen],
					((curmen==0) && (labelmode==0))?menu_count[curmen]-1:menu_count[curmen]);
			}
			else if (comm == ES_GOTO) {
				parload = !parload;
				parcom = comm;
				/* parameter required */
				clear_top_line();
				sprintf(messg,"Parameter (ESC to cancel) : ");
				digprompt(messg);
				inptr=0;
			}
			else if (comm == ES_CURSOR_LEFT) {
				if (left > 0) {
					digline(digitab.lbun,left,yb,left,yt);
					digflush();
					left -= 1/digdata.xscale;
					if (left < xl) left = xl;
					digline(digitab.lbun,left,yb,left,yt);
					digflush();
					newstart = *start + (left-xl)/digitab.scalex;
				}
			}
			else if (comm == ES_CURSOR_RIGHT) {
				if (left > 0) {
					digline(digitab.lbun,left,yb,left,yt);
					digflush();
					left += 1/digdata.xscale;
					if (left > xr) left = xr;
					digline(digitab.lbun,left,yb,left,yt);
					digflush();
					newstart = *start + (left-xl)/digitab.scalex;
				}
			}
			else if (comm == ES_ACTION) {
				if (labelmode && (ansel >= 0)) {
					if (left > 0) { digline(digitab.lbun,left,yb,left,yt); digflush(); }
					if (right > 0) { digline(digitab.lbun,right,yb,right,yt); digflush(); }
					diglinemode(0);
					movan(ansel,newstart,*start,*stop);
					ansel = -1;
					diglinemode(1);
					if (left > 0) { digline(digitab.lbun,left,yb,left,yt); digflush(); }
					if (right > 0) { digline(digitab.lbun,right,yb,right,yt); digflush(); }
				}
			}
		}
		digflush();
		fflush(stdout);	/* just in case */

	} while (comm < ES_EXTERNAL);

	/* delete cursors */
	if (left > 0) { digline(digitab.lbun,left,yb,left,yt); digflush(); }
	if (right > 0) { digline(digitab.lbun,right,yb,right,yt); digflush(); }

	/* wait for button up */
	while (button) {
		ch=diggetmousech(&button,&mousex,&mousey);
	}
	obutton=0;

fastexit:
	/* close mouse */
	diglinemode(0);
	digkillmouse();

	if (newstart > newstop) {
		*start=newstop;
		*stop=newstart;
	}
	else {
		*start=newstart;
		*stop=newstop;
	}
	if (*stop < (*start+0.001)) *stop = *start + 0.001;

	return(comm);
}

/* get mouse box command */
#ifdef __STDC__
int getboxcom(int ch,int button,float x,float y,int curmen)
#else
int getboxcom(ch,button,x,y,curmen)
int	ch,button;
float	x,y;
int	curmen;
#endif
{
	int	i,com;

	if (!ch && !button)
		return(ES_NULL);
	if ((com = esmenu_check(x,y,ch)) < 0) {
		for (i=0;i<NUMSPECIALCOMM;i++)
			if (ch==specialcomm[i].lett)
				return(specialcomm[i].comm);
		return(ES_NULL);
	}
	if (ch>0) {
		if (isupper(ch)) ch = tolower(ch);
		for (i=0;i<4;i++)
			if ((ch==menu_map[curmen][com].command[i].lett) ||
			    (menu_map[curmen][com].command[i].lett=='\0'))
				return(menu_map[curmen][com].command[i].comm);
	}
	else if (button) {
		for (i=0;i<4;i++)
			if (menu_map[curmen][com].command[i].mask & button)
				return(menu_map[curmen][com].command[i].comm);
	}
	return(ES_NULL);
}
