/* sman -- create manual page from source file (!) */

/* m.a.huckvale -- may 1986 */

/* version 1.0 */

#define PROGNAME "sman"
#define PROGVERS "1.0"

/*--------------------------------------------------------------------------*/
/**MAN
.TH SMAN 1 UCL SPAR
.PM P
.SH NAME
sman - filter out manual page from source file
.SH SYNOPSIS
.B sman
(sourcefile(s))
.SH DESCRIPTION
.I sman 
reads text from its standard input or the filenames supplied and copies to the
text formatting program "nroff" any text found between the markers /\****MAN 
and *\/. 
It is used to print manual pages from SPAR source files (where authors
are requested to include the manual page in the file).  A suitable 
command line for printing is :
        sman file.c | lpr
.br
"nroff" is called with the "-man" option, using the manual page macros found 
in /usr/lib/macros/an.
.br
To print "*\/" use "*\\/".
.SH VERSION/AUTHOR
1.0 - Mark Huckvale
*/
/*--------------------------------------------------------------------------*/

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"

int	flag;

#ifdef __STDC__
void process(FILE *,FILE *);
#else
void process();
#endif

int main(argc,argv)
int	argc;
char	*argv[];
{
	int	i;
	FILE	*fp,*op;

	/* open pipe to nroff */
#ifdef DOS
	op = stdout;
#else
	if ((op = popen("nroff -man","w")) == NULL) {
		fprintf(stderr,"%s: unable to open pipe to nroff\n",argv[0]);
		exit(1);
	}
#endif
	/* process standard input or given files */
	if (argc == 1)
		process(stdin,op);
	else {
		for (i=1;i<argc;i++) {
			if (strcmp(argv[i],"-I")==0) {
				fprintf(stderr,"%s: Extract SFS manual page V%s\n",
					PROGNAME,PROGVERS);
				exit(0);
			}
			else if ((fp=fopen(argv[i],"r")) == NULL) {
				fprintf(stderr,"%s: can't open %s\n",argv[0],argv[i]);
				exit(1);
			}
			else {
				flag = 0;
				process(fp,op);
				fclose(fp);
				if (flag == 0)
					fprintf(stderr,"%s: no manual page in %s\n",argv[0],argv[i]);
			}
		}
	}
#ifndef DOS
	pclose(op);
#endif
	exit(0);
}

/* process a file */
void process(fp,op)
FILE	*fp,*op;
{
	int	c,d;
	while ((c = getc(fp)) != EOF) {
		if (c == '/') {
		  c = getc(fp);
		  if (c == '*') {
		    c = getc(fp);
		    if (c == '*') {
		      c = getc(fp);
		      if (c == 'M') {
		        c = getc(fp);
		        if (c == 'A') {
			  c = getc(fp);
			  if (c == 'N') {
			    c = getc(fp);
			    if (c == '\n') {
			      d = getc(fp);
			      while (((c = getc(fp)) != EOF) && !((d == '*') && (c == '/'))) {
			        putc(d,op);
		  	        d = c;
				flag = 1;
			      }
			    }
			  }
		        }
		      }
		    }
		  }
		}
	}
}
