/* anframe -- list annotations as frame labels */

/* M.A.Huckvale - University College London */

/* version 1.0 - August 1994 */

/* version 1.1 - September 1994
	- add -ico switch to specify overall length
*/

#define PROGNAME "anframe"
#define PROGVERS "1.1"
char *progname=PROGNAME;

/*-------------------------------------------------------------------------*/
/**MAN
.TH ANFRAME SFS1 UCL
.SH NAME
anframe - list annotations as frame labels
.SH SYNOPSIS
.B anframe
(-i item) (-f framerate) file
.SH DESCRIPTION
.I anframe
divides annotations up into frames and prints the frame names
across a single output line.  The default frame time is 10ms.
.SH OPTIONS
.TP 11
.B -I
Identify program name and version number.
.TP 11
.BI -i item
Select input item number. A specified annotation item controls which
annotations to list, a specified CO item determines the overall
duration.
.TP 11
.BI -f framerate
Specify frame rate.  Default 100 frames/sec.
.SH INPUT ITEMS
.IP AN 
Input annotations
.SH VERSION/AUTHOR
.IP 1.0
Mark Huckvale
.SH SEE ALSO
anlist, antier, anmap
.SH BUGS
*/
/*--------------------------------------------------------------------------*/

#include <stdio.h>
#include <math.h>
#include <string.h>
#include "sfs.h"

struct item_header anitem;
struct an_rec	*an;
double	fdur=0.01;
struct item_header coitem;
struct co_rec	*co;
int	doco=0;
double	endtime=-1;

/* main program */
main(argc,argv)
int	argc;
char	*argv[];
{
	/* option decoding */
	extern int	optind;		/* option index */
	extern char	*optarg;	/* option argument ptr */
	int		errflg = 0;	/* option error flag */
	int		c;		/* option switch */
	int		it;		/* item selection */
	char		*ty;		/* item sub type */
	char		*antype="0";
	char		*cotype="0";
	/* file variables */
	char		filename[SFSMAXFILENAME]; /* SFS data file name */
	int		fid;
	int		i;
	double		t,et;

	/* decode switches */
	while ( (c = getopt(argc,argv,"Ii:f:")) != EOF ) switch (c) {
		case 'I' :	/* Identify */
			fprintf(stderr,"%s: List annotations as frame labels V%s\n",PROGNAME,PROGVERS);
			exit(0);
			break;
		case 'i' :	/* specific item */
			if (itspec(optarg,&it,&ty) == 0) {
				if (it == AN_TYPE)
					antype = ty;
				else if (it == CO_TYPE) {
					cotype = ty;
					doco=1;
				}
				else
					error("unsuitable item specifier %s",optarg);
			}
			else
				error("illegal item specifier %s",optarg);
			break;
		case 'f' :
			fdur = 1.0/atof(optarg);
			break;
		case '?' :	/* unknown */
			errflg++;
	}
	if (errflg || (argc<2))
		error("usage: %s (-I) (-i anitem) (-i coitem) (-f framerate) file",PROGNAME);

	/* get filename */
	if (optind < argc)
		strcpy(filename,sfsfile(argv[optind]));
	else
		error("no database file specified",NULL);

	/* load annotations */
	getitem(filename,AN_TYPE,antype,&anitem,&an);

	/* if coefficient item specified, get final time */
	if (doco) {
		fid=sfsopen(filename,"r",NULL);
		if (sfsitem(fid,CO_TYPE,cotype,&coitem)) {
			co = (struct co_rec *)sfsbuffer(&coitem,1);
			if (sfsread(fid,coitem.numframes-1,1,co)==1)
				endtime = coitem.offset + (co->posn+co->size)*coitem.frameduration;
		}
		sfsclose(fid);
	}

	/* dump as frame labels */
	t=0;
	if (endtime < 0) endtime = anitem.offset+(an[anitem.numframes-1].posn+an[anitem.numframes-1].size)*anitem.frameduration;
	for (i=0;(t+fdur < endtime) && (i<anitem.numframes);i++) {
		if (i < anitem.numframes-1)
			et = anitem.offset+(an[i+1].posn*anitem.frameduration);
		else
			et = endtime;
		if (et > endtime) et=endtime;
		while ((t+fdur) <= et) {
			printf("%s ",an[i].label);
			t += fdur;
		}
		if ((t+fdur/2) < et) {
			printf("%s ",an[i].label);
			t += fdur;
		}
	}
	printf("\n");
	exit(0);
}

