/* graph -- demonstrate graph plotting */

file gop

/* plot spectrum cross section */
function var plotcross(t)
{
	var	t
	var f,xdata[0:100],ydata[0:100],ynum
	for (f=50;f<=5000;f=f+50) {
		xdata[ynum]=f
		ydata[ynum]=energy(f,t)
		if (ydata[ynum]) ynum=ynum+1
	}
	plotparam("type=line")
	plotparam("char=")
	plotxdata(xdata,0)
	plot(gop,1,ydata,ynum)
}

/* plot formant positions */
function var plotformants(t)
{
	var	t
	var	i,xdata[0:4],ydata[0:4],ynum
	for (i=1;i<=4;i=i+1) {
		xdata[ynum]=sy(3*i,t)
		ydata[ynum]=sy(3*i+1,t)/10
		if (xdata[ynum]) ynum=ynum+1
	}
	plotparam("type=point")
	plotparam("char=F")
	plotxdata(xdata,0)
	plot(gop,1,ydata,ynum)
}

/* init plots */
init {
	string	ans
	print "Send graphs to printer ? (Y/N) "
	input ans
	if (index("^[Yy]",ans)) openout(gop,"|dig -p") else gop=stdout
	plotparam("xtitle=Frequency (Hz)")
	plotparam("ytitle=Amplitude (dB)")
}

main {
	if ($filecount > 1) plotclear(gop)
	plottitle(gop,$filename++": spectrum + formants")
	plotaxes(gop,1,0,5000,0,80)
	plotcross(time("1"))
	plotformants(time("1"))
}
