{ dft.inc -- Discrete Fourier Transform Routines for SPC }

{ M.A.Huckvale - December 1991 }

const
	MAXDFTSIZE = 8192;
type
	realspectrum = array[0..MAXDFTSIZE] of real;

function HammingWindow(wv:waveform):realwave;
var
	i:integer;
	factor:real;
	rwv:realwave;
	iend:integer;
begin
	if wv._size > MAXDFTSIZE then begin
		writeln('DFT: waveform too big');
		iend:=0;
	end
	else begin
		factor := 2 * PI / (wv._size-1);
		for i:=0 to wv._size-1 do
			rwv[i] := wv._data[i] * (0.54 - 0.46 * cos(i*factor));
		iend := wv._size;
	end;
	for i:=iend to MAXDFTSIZE-1 do rwv[i] := 0;
	HammingWindow := rwv;
end;

external procedure rFFTmag(var rwv:realwave;var spect:realspectrum;loglen:integer);

function DFT(rwv:realwave;len:integer;var spect:realspectrum):integer;
var
	pow2:integer;
	log2:integer;
begin
	{ get window size }
	log2 := 0;
	pow2 := 1;
	while pow2 < len do begin
		pow2 := pow2 * 2;
		log2 := log2 + 1;
	end;

	{ perform DFT }
	if pow2 > MAXDFTSIZE then begin
		writeln('DFT: waveform too big');
		DFT := 0;
	end
	else begin
		rFFTmag(rwv,spect,log2);
		DFT := pow2 div 2;
	end;
end;

