/* kspan.h -- standard macros for K-SPAN */

#define fx(v) F0(v,LIN)
#define f0(v) F0(v,LIN)
#define av(v) AV(v,LIN)
#define oq(v) OQ(v,LIN)
#define sq(v) SQ(v,LIN)
#define tl(v) TL(v,LIN)
#define fl(v) FL(v,LIN)
#define di(v) DI(v,LIN)
#define ah(v) AH(v,LIN)
#define af(v) AF(v,LIN)
#define f1(v) F1(v,LIN)
#define b1(v) B1(v,LIN)
#define df1(v) DF1(v,LIN)
#define db1(v) DB1(v,LIN)
#define f2(v) F2(v,LIN)
#define b2(v) B2(v,LIN)
#define f3(v) F3(v,LIN)
#define b3(v) B3(v,LIN)
#define f4(v) F4(v,LIN)
#define b4(v) B4(v,LIN)
#define f5(v) F5(v,LIN)
#define b5(v) B5(v,LIN)
#define f6(v) F6(v,LIN)
#define b6(v) B6(v,LIN)
#define fnp(v) FNP(v,LIN)
#define bnp(v) BNP(v,LIN)
#define fnz(v) FNZ(v,LIN)
#define bnz(v) BNZ(v,LIN)
#define ftp(v) FTP(v,LIN)
#define btp(v) BTP(v,LIN)
#define ftz(v) FTZ(v,LIN)
#define btz(v) BTZ(v,LIN)
#define a2f(v) A2F(v,LIN)
#define a3f(v) A3F(v,LIN)
#define a4f(v) A4F(v,LIN)
#define a5f(v) A5F(v,LIN)
#define a6f(v) A6F(v,LIN)
#define ab(v) AB(v,LIN)
#define b2f(v) B2F(v,LIN)
#define b3f(v) B3F(v,LIN)
#define b4f(v) B4F(v,LIN)
#define b5f(v) B5F(v,LIN)
#define b6f(v) B6F(v,LIN)
#define anv(v) ANV(v,LIN)
#define a1v(v) A1V(v,LIN)
#define a2v(v) A2V(v,LIN)
#define a3v(v) A3V(v,LIN)
#define a4v(v) A4V(v,LIN)
#define atv(v) ATV(v,LIN)

#define at(t)	AT(t)
#define wait(t)	WAIT(t)
#define length(t) LENGTH(t)

#define DEFAULT_PARAMETERS { \
		/* source */ \
		f0(100); av(60); oq(50); sq(200); \
		tl(0); fl(0); di(0); ah(0); af(0); \
		/* series formants */ \
		f1(500); b1(60); df1(0); db1(0); \
		f2(1500); b2(90); f3(2500); b3(150); \
		f4(3250); b4(200); f5(3700); b5(200); \
		f6(4990); b6(500); \
		/* nasal & tracheal pole-zero */ \
		fnp(280); bnp(90); fnz(280); bnz(90); \
		ftp(2150); btp(180); ftz(2150); btz(180); \
		/* frication formants */ \
		a2f(0); a3f(0); a4f(0); a5f(0); a6f(0); ab(0); \
		b2f(250); b3f(300); b4f(320); b5f(360); b6f(1500); \
		/* parallel formants */ \
		a1v(0); a2v(0); a3v(0); a4v(0); atv(0); \
			}

#define SILENCE { \
		av(0); ah(0); af(0); \
		a2f(0); a3f(0); a4f(0); a5f(0); a6f(0); ab(0); \
		a1v(0); a2v(0); a3v(0); a4v(0); atv(0); \
		}

#define SILENCE_FIX { \
		AV(0,FIX); AH(0,FIX); AF(0,FIX); \
		A2F(0,FIX); A3F(0,FIX); A4F(0,FIX); A5F(0,FIX); A6F(0,FIX); AB(0,FIX); \
		A1V(0,FIX); A2V(0,FIX); A3V(0,FIX); A4V(0,FIX); ATV(0,FIX); \
		}

