/* DSP routines from Mike Brookes, Imperial College London */

typedef double REAL;
typedef struct { REAL r,i; } COMPLEX;
typedef struct { REAL mod,arg; } POLAR;

#ifndef PI
#define PI	3.14159265359
#endif
#define E 	2.718281828
#define ROOT2	1.4142135624
#define LOG10	2.302585093

/* function prototypes for IC DSP library */
#ifdef __STDC__
void cbitrev(COMPLEX *data,int len);
void cfdift(COMPLEX *data,int m,int len);
void dftc(COMPLEX *data,COMPLEX *spect,int len);
void dftci(COMPLEX *data,COMPLEX *spect,int len);
void dftr(REAL *data,COMPLEX *spect,int len);
void dpsr(REAL *data,REAL *spect,int len);
void exptable(int len,COMPLEX **table);
void fftc(COMPLEX *data,COMPLEX *spect,int len);
void fftci(COMPLEX *data,COMPLEX *spect,int len);
void fftr(REAL *data,COMPLEX *spect,int len);
void fpsr(REAL *data,REAL *spect,int len);
int log2ch(int len);
void makechirp(int len,int *halftlen,COMPLEX **table);
void rbitrev(REAL *data,int len);
void rsplfft(REAL *data,int n,int m);
void sintable(int logn,REAL **table,int *inc);
#else
#endif

