/* lsys.h -- definitions for general Linear System routines */

/*
 * (c) 1994 Mark Huckvale
 * Search Systems Ltd
 * 52-54 High Holborn
 * London WC1E 6BT
 * Tel. 071-430 1685
 */

/* definition of a general linear system */
#define MAXLTISIZE	100

struct LTI_rec {
	double	a[MAXLTISIZE+1];	/* numerator (x's), a[0]=gain */
	int	na;			/* numerator size */
	double	b[MAXLTISIZE+1];	/* denominator (y's) */
	int	nb;			/* denominator size */
	double	smem[MAXLTISIZE+1];	/* state memory */
};

typedef struct LTI_rec LTIState;

/* lsys.c */
#ifdef __STDC__
void LTISystemClear(LTIState *ltis);
double LTISystem(LTIState *ltis, double x);
double LTISystemResponse(LTIState *ltis,double f);
#else
void LTISystemClear();
double LTISystem();
double LTISystemResponse();
#endif
