/* definitions for SFS network with UCL file server */

/* define NETWORK if network active on this machine */
#define NETWORK

#ifdef NETWORK

/* external defintions for network */
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

/* manifest constants */
#define PORTNUM	1112		/* port # for UCL file server */
#define BUFSIZE 512		/* standard bufsize for UCL file server */
#define FILESTAT 1001		/* get file status */
#define READDATA 1002		/* return file data */

/* UCL file server request structure */
struct reqrec {
	short	reqid;		/* request id */
	short	status;		/* returned status */
	short	mode;		/* file mode */
	short	spare;		/* spare */
	long	start;		/* file offset */
	long	length;		/* file length */
	char	buff[BUFSIZE];	/* data buffer */
};

#endif
