/* gclip -- define graphics clipping region */

#include <stdio.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"

#ifdef __STDC__
void   digclip(float  xmin,float  ymin,float  xmax,float  ymax)
#else
void	digclip(xmin,ymin,xmax,ymax)
float	xmin,xmax,ymin,ymax;
#endif
{
	digdata.clipxmin = xpix(xmin);
	digdata.clipxmax = xpix(xmax);
	digdata.clipymin = ypix(ymin);
	digdata.clipymax = ypix(ymax);
}

struct digclipblock {
	struct digclipblock 	*last;
	int			xmin;
	int			xmax;
	int			ymin;
	int			ymax;
};

static struct digclipblock	*digcliphead=NULL;

int	digclippush()
{
	struct digclipblock *ptr;
	ptr = (struct digclipblock *) malloc(sizeof(struct digclipblock));
	if (ptr == NULL) return(-1);
	ptr->xmin = digdata.clipxmin;
	ptr->xmax = digdata.clipxmax;
	ptr->ymin = digdata.clipymin;
	ptr->ymax = digdata.clipymax;
	ptr->last = digcliphead;
	digcliphead = ptr;
	return(0);
}

int	digclippop()
{
	struct digclipblock *ptr;
	ptr = digcliphead;
	if (ptr == NULL) return(-1);
	digcliphead = ptr->last;
	digdata.clipxmin = ptr->xmin;
	digdata.clipxmax = ptr->xmax;
	digdata.clipymin = ptr->ymin;
	digdata.clipymax = ptr->ymax;	
	free(ptr);
	return(0);
}

#ifdef EMO
main()
{
	digstart('\0',NULL,0);
	digscale (4.0,4.0,0);
	digorigin(2.0,2.0);
	digclip(-1.0,-1.0,1.0,1.0);

	/* Draw the clip limit	*/

	digline(20,-1.0,-1.0,-1.0,1.0);
	digline(20,-1.0,1.0,1.0,1.0);
	digline(20,1.0,1.0,1.0,-1.0);
	digline(20,1.0,-1.0,-1.0,-1.0);

	/* Draw a rotated square	*/

	digline(25,-1.3,-0.6,-0.6,1.3);
	digline(25,-0.6,1.3,1.3,0.6);
	digline(25,1.3,0.6,0.6,-1.3);
	digline(25,0.6,-1.3,-1.3,-0.6);

	digend();
}
#endif
