/* masscomp -- DIG routines for MASSCOMP graphics displays and Graphics Compatibility Library */

/* Mark Huckvale - April 1990 */

/* version 1 - April 1990
	- still highly specific for 6-plane colour
	- uses mgiimage (unsupported in GCL)
*/

#include "SFSCONFG.h"
#ifdef EVm

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <fcntl.h>
#include "dig.h"
#include "digdata.h"

/* masscomp graphics */
#define	MASHOME		"\033[H"
#define	MASCLEAREOL	"\033[0K"
#define TEXTFONT "5x7_italic" 		/* default "hardware" font */

/* global data */
struct {
	short mode;		/* 0=?, 1=initialised */
	short rop;		/* raster operation */
} digDEVm;

/* device characteristics */
mass_params(subtype,digdev)
int	subtype;
struct digdevice *digdev;
{
	int	xleft,ybottom,xright,ytop,placed;
	if (!(digDEVm.mode)) {
		mgiasngp(0,0) ;
		mgifetchgf(0,TEXTFONT);
		pushcolmap();
		initcolmap();
		digDEVm.mode++;
	}
	/* get co-ordinates of current viewport */
	mgigetvcoor(2,&xleft,&ybottom,&xright,&ytop,&placed);
	digdev->nhoriz = xright - xleft +1;
	digdev->nvert  = ytop - ybottom + 1;
	digdev->aspect = 1.0;
	digdev->chwidth = 7;
	digdev->chheight = 9;
	digdev->greylevels = 16;
	digdev->greypixwidth = 1;
	digdev->greypixheight = 1;
	/* should use subtype (?) to differentiate Masscomp GPs */

}

/* open graphics */
mass_open()
{
	/* done already with mgiasngp() */
}

/* interrupt graphics */
mass_inter()
{
	fprintf(stderr,"Interrupt\n");
	fflush(stderr);
}

/* close graphics - return to text mode */
mass_close()
{
	mgiclearpln (2,-1,0) ;
	popcolmap();
	mgideagp();
	digDEVm.mode = 0;
}

/* clear screen */
mass_clear()
{
	mgiclearpln (2,-1,0) ;
}

/* set up colour from bundle */
static mass_colour(bundle)
int	bundle;
{
	if (!bundle)
		mgihue (0) ;
	else 
		mgihue ( 1 + ( bundle + 10 ) % 15 ) ;
	if (bundle < 35) mgidash(2,1);
	else if (bundle < 50) mgidash(2,0xC);
	else if (bundle < 65) mgidash(2,0x38);
	else if (bundle < 80) mgidash(2,0xF0);
	else if (bundle < 95) mgidash(2,0x3E0);
	else mgidash(2,0xE4);
}

/* draw a poly-line */
mass_polyline(bundle,buff,len)
int	bundle;
short	*buff;
int	len;
{
	int	x,y,xold,yold;

	mgiv (2) ;

	/* sort out colours */
	mass_colour(bundle);

	/* position to first point */
	xold = *buff++;
	yold = *buff++;
	len -= 2;

	/* plot rest of points */
	while (len > 0) {
		x = *buff++;
		y = *buff++;
		if (bundle < 20) {
			/* Need routine to do thick lines ! */
			mgil(xold,yold,x,y);
			mgil(xold,yold+1,x,y+1);
			mgil(xold+1,yold,x+1,y);
		}
		else
			mgil (xold,yold,x,y);
		xold = x;
		yold = y;
		len -= 2;
	}

	mgidash(2,1);
}

/* draw 'hardware' text */
mass_text(bundle,x,y,str)
int	bundle;
int	x,y;
char	*str;
{

	/* sort out colours */
	mass_colour(bundle);

	/* draw text */
	mgigf(0);
	if (*str) mgigfs(x,y,0,str);
	mgisyncrb(1);
}

/* draw a filled rectangle */
mass_fillrect(bundle,x1,y1,x2,y2)
int	bundle;
int	x1,y1,x2,y2;
{
	/* sort out colours */
	mass_colour(bundle);

	/* draw filled box */
	mgiv(2);
	mgibox (x1,y1,x2,y2);
}

/* change line/text raster operation */
mass_rasterop(mode)
int	mode;
{
	int	ret;
	if (mode)
		mgimodfunc(3,4,3);
	else
		mgimodfunc(3,0,0);
	ret=digDEVm.rop;
	digDEVm.rop=mode;		
	return(ret);
}

/* initialise pointing device */
mass_pointer(flag,xm,ym)
int	flag;
int	xm,ym;
{
	extern int	errno;
	struct termio 	newmode;

	if (flag) {
		/* open channel to terminal in raw mode */
		if (digdata.tty == -1) {
			if ((digdata.tty = open ("/dev/tty",O_RDONLY | O_NDELAY)) >= 0) {
				ioctl(digdata.tty,TCGETA,&digdata.oldmode);
				newmode = digdata.oldmode;
				newmode.c_lflag = newmode.c_lflag & ~ICANON;
				newmode.c_lflag = newmode.c_lflag & ~ECHO;
				newmode.c_cc[4]=1;		/* 1 character burst */
				newmode.c_cc[5]=0;		/* wait */
				ioctl(digdata.tty,TCSETA,&newmode);
			}
			else {
				fprintf(stderr,"diginitmouse: unable to open keyboard, errno=%d\n",errno);
				return(-1);
			}
		}
		mgicursmode(0);
		mgicursxy(2,6,xm,ym);
		mgicursmode(7);
		mgibtnmode(1);
	}
	else {
		/* restore keyboard */
		if (digdata.tty >= 0) {
			ioctl(digdata.tty,TCFLSH,0);
			ioctl(digdata.tty,TCSETA,&digdata.oldmode) ;
			close(digdata.tty);
		}
		digdata.tty = -1;
		mgicursmode(0);
		mgibtnmode(0);
	}
}

/* get mouse/key status */
mass_mouse(but,xm,ym,ich)
int	*but;
int	*xm;
int	*ym;
int	*ich;
{
	static int	butold=0,xmold=0,ymold=0;
	char	ch;

	*but = butold;
	*xm = xmold;
	*ym = ymold;
	*ich = 0;

	do {
		if (read(digdata.tty,&ch,1)==1) {
			*ich = ch;
			return(DIG_KEY);
		}	
		/* check for a mouse button event */
		if (mgigetbtnevent(50,xm,ym,but)==0) {
			butold = *but;
			xmold  = *xm;
			ymold  = *ym;
			return(DIG_MOUSE);
		}
	} while (1);
}

/* display text on prompt line */
mass_prompt(str)
char	*str;
{
	printf(MASHOME);
	printf ("%s",str) ;
	printf(MASCLEAREOL);
	fflush (stdout) ;
}

static unsigned char	grey[16]={
				0x7C,0x78,0x74,0x70,
				0x6C,0x68,0x64,0x60,
				0x5C,0x58,0x54,0x50,
				0x4C,0x48,0x44,0x40
				 };

/* grey-level display */
mass_gscale(x,y,height,buff)
int	x,y;
int	height;
unsigned char	*buff;
{
	int		i;
	unsigned char	*p;
	
	/* replace greyscales by colours */
	p=buff;
	for (i=0;i<height;i++,p++)
		*p = grey[*p];

	mgiv(2);
	mgiimage(buff,x,y+1,x,y+height);
	mgisyncrb(1);
}

/* initialise Masscomp 6-plane colour map */
initcolmap () 
{
	/* drawing planes */
	mgicm (0,0x000000);	/* black */
	mgicm (1,0xD00000);	/* red */
	mgicm (2,0x60E080);	/* very-light-green */
	mgicm (3,0x70A0F0);	/* very-light-blue */
	mgicm (4,0xF0F000);	/* yellow */
	mgicm (5,0xF0F0F0);	/* white */
	mgicm (6,0xF09000);	/* orange */
	mgicm (7,0x700080);	/* slightly-bluish purple */
	mgicm (8,0x007090);	/* geenish-blue */
	mgicm (9,0xF07080);	/* very-light-red */
	mgicm (10,0x3070E0);	/* light-blue */
	mgicm (11,0x800080); 	/* purple */
	mgicm (12,0xF07000);	/* reddish-orange */
	mgicm (13,0x9060A0);	/* grayish-purple */
	mgicm (14,0x805030);	/* very-light-brown */
	mgicm (15,0xC0F000);	/* greenish-yellow */
	mgicm (16,0x000000);	/* black */
	mgicm (17,0x101010);	/* dark grey */
	mgicm (18,0x202020);
	mgicm (19,0x303030);
	mgicm (20,0x404040);
	mgicm (21,0x505050);
	mgicm (22,0x606060);
	mgicm (23,0x707070);
	mgicm (24,0x808080);
	mgicm (25,0x909090);
	mgicm (26,0xA0A0A0);
	mgicm (27,0xB0B0B0);
	mgicm (28,0xC0C0C0);
	mgicm (29,0xD0D0D0);
	mgicm (30,0xE0E0E0);	/* light grey */
	mgicm (31,0xF0F0F0);	/* white */
/* text/cursor plane */
	mgicm (32,0xF0F0F0);	/* black */
	mgicm (33,0xF0F0F0);	/* red */
	mgicm (34,0x000000);	/* very-light-green */
	mgicm (35,0x000000);	/* very-light-blue */
	mgicm (36,0x000000);	/* yellow */
	mgicm (37,0x000000);	/* white */
	mgicm (38,0x000000);	/* orange */
	mgicm (39,0xF0F0F0);	/* slightly-bluish purple */
	mgicm (40,0xF0F0F0);	/* geenish-blue */
	mgicm (41,0x000000);	/* very-light-red */
	mgicm (42,0x000000);	/* light-blue */
	mgicm (43,0xF0F0F0); 	/* purple */
	mgicm (44,0xF0F0F0);	/* reddish-orange */
	mgicm (45,0xF0F0F0);	/* grayish-purple */
	mgicm (46,0x000000);	/* very-light-brown */
	mgicm (47,0x000000);	/* greenish-yellow */
	mgicm (48,0xF0F0F0);	/* black */
	mgicm (49,0xF0F0F0);	/* dark grey */
	mgicm (50,0xF0F0F0);
	mgicm (51,0xF0F0F0);
	mgicm (52,0xF0F0F0);
	mgicm (53,0xF0F0F0);
	mgicm (54,0xF0F0F0);
	mgicm (55,0xF0F0F0);
	mgicm (56,0x000000);
	mgicm (57,0x000000);
	mgicm (58,0x000000);
	mgicm (59,0x000000);
	mgicm (60,0x000000);
	mgicm (61,0x000000);
	mgicm (62,0x000000);	/* light grey */
	mgicm (63,0x000000);	/* white */

}

/* Colour map stacking */
struct colmapblock {
	struct colmapblock 	*last;
	int			cols[64];
};

static struct colmapblock	*colmaphead=NULL;

pushcolmap()
{
	struct colmapblock *ptr;
	ptr = (struct colmapblock *) malloc(sizeof(struct colmapblock));
	if (ptr == NULL) return(-1);
	mgigetcms(0,64,ptr->cols);
	mgisyncrb(1);
	ptr->last = colmaphead;
	colmaphead = ptr;
	return(0);
}

popcolmap()
{
	struct colmapblock *ptr;
	ptr = colmaphead;
	if (ptr == NULL) return(-1);
	colmaphead = ptr->last;
	mgicms(0,64,ptr->cols);
	mgisyncrb(1);
	free(ptr);
	return(0);
}

#endif
