/* skeleton -- skeleton DIG routines for a new device */

/* Mark Huckvale - University College London */

/* version 1.0 - April 1990 */
/* version 2.0 - April 1993 */

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"

#ifdef EV?		/* <- letter chosen for device type */

/* global data */
struct {
	short mode;		/* 0=?, 1=initialised */
	short rop;		/* raster operation */
	short currbun;		/* current bundle */
	short rop;		/* raster operation */
	short xmouse,ymouse,smouse; /* mouse status */
} digDEV?;

/* device characteristics */
????_params(subtype,digdev)
int	subtype;
struct digdevice *digdev;
{
	if (!(digDEV?.mode)) {		/* may need to open */
		????_open();
	}
	digdev->nhoriz = ;
	digdev->nvert  = ;
	digdev->aspect = 1.0;
	digdev->chwidth = 8;
	digdev->chheight = 8;
	digdev->greylevels = 7;
	digdev->greypixwidth = 1;
	digdev->greypixheight = 1;
}

/* open graphics */
????_open()
{
	if (!(digDEV?.mode)) {
		/* change to graphics mode */
	
		(digDEV?.mode)++;
		digDEV?.currbun=24;
		digDEV?.rop=0;
	}
}

/* interrupt graphics */
????_inter()
{
	/* deal with interrupted drawing */
	????_close();
	fprintf(stderr,"Interrupt\n");
	fflush(stderr);
}

/* close graphics - return to text mode */
????_close()
{
	/* return to text mode */
	digDEV?.mode = 0;
}

/* clear screen */
????_clear()
{
	/* clear screen to background */
}

/* set up colour from bundle */
static ????_colour(bundle)
int	bundle;
{
	/* bundles are 0=background,1-100 various colours/line styles */
	
}

/* draw a poly-line */
????_polyline(bundle,buff,len)
int	bundle;
short	*buff;
int	len;
{
	int	x,y;

	/* sort out colours */
	????_colour(bundle);

	/* position to first point */
	x = *buff++;
	y = *buff++;
	len -= 2;
	/* move to x,y */

	/* plot rest of points */
	while (len > 0) {
		x = *buff++;
		y = *buff++;

		/* plot line to x,y */
		len -= 2;
	}

}

/* draw 'hardware' text */
????_text(bundle,x,y,str)
int	bundle;
int	x,y;
char	*str;
{

	/* sort out colours */
	????_colour(bundle);

	/* write string */
}

/* draw a filled rectangle */
????_fillrect(bundle,x1,y1,x2,y2)
int	bundle;
int	x1,y1,x2,y2;
{
	/* sort out colours */
	????_colour(bundle);

	/* draw filled box */
}

/* change line/text raster operation */
????_rasterop(mode)
int	mode;
{
	int	ret;

	/* set new raster op 0=write, 1=xor */

	ret=digDEV?.rop;
	digDEV?.rop=mode;
	return(ret);
}

/* draw a circle */
????_circle(bundle,xc,yc,r)
int	bundle;
int	xc,yc,r;
{
	/* sort out colours */
	????_colour(bundle);

	/* draw a circle */
}

/* draw a filled circle */
????_fcircle(bundle,xc,yc,r)
int	bundle;
int	xc,yc,r;
{
	/* sort out colours */
	????_colour(bundle);

	/* draw a filled circle */
}

/* initialise pointing device */
????_pointer(flag,xm,ym)
int	flag;
int	xm,ym;
{
	if (flag) {
		/* turn mouse on */
	}
	else {
		/* turn mouse off */
	}
}

/* get keyboard & mouse input */
????_mouse(but,xm,ym,ich)
int	*but;
int	*xm;
int	*ym;
int	*ich;
{
	char	ch='\0';

	*xm = digDEV?.xmouse;
	*ym = digDEV?.ymouse;
	*but = digDEV?.smouse;

	/* get a character if waiting */
	if ( /* key */ ) {
		*ich = ch;
		return(DIG_KEY);
	}
	/* check for a mouse button event */
	else if ( /* mouse */ ) {
		*xm=digDEV?.xmouse;
		*ym=digDEV?.ymouse;
		*but=digDEV?.smouse;
		*ich=0;
		return(DIG_MOUSE);
	}
	return(0);
}

/* display text on prompt line */
????_prompt(str)
char	*str;
{

}

/* grey-level display */
????_gscale(x,y,height,buff)
int	x,y;
int	height;
unsigned char	*buff;
{
}

/* pause for user input */
int ????_pause()
{

}

#endif
