/* digitemtime -- timescale routine for digitem library */

/* version 1.0 - M.A.Huckvale - June 1987 */

#include <stdio.h>
#include <fcntl.h>
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

static struct {
	double	time;		/* units for scale factor */
	double	scale;		/* scale factor */
	char	*label;		/* scale label */
	char	*format;	/* printf format */
} timtab[]=
{
	{ 3600.0,	3600.0,	"hr",	"%.0f" },
	{ 600.0,	60.0,	"min",	"%.0f" },
	{ 300.0,	60.0,	"min",	"%.0f" },
	{ 120.0,	60.0,	"min",	"%.0f" },
	{ 60.0,	60.0,	"min",	"%.0f" },
	{ 20.0,	1.0,	"s",	"%.0f" },
	{ 10.0,	1.0,	"s",	"%.0f" },
	{ 5.0,	1.0,	"s",	"%.0f" },
	{ 2.0,	1.0,	"s",	"%.0f" },
	{ 1.0,	1.0,	"s",	"%.0f" },
	{ 0.5,	1.0,	"s",	"%.1f" },
	{ 0.2,	1.0,	"s",	"%.1f" },
	{ 0.1,	1.0,	"s",	"%.1f" },
	{ 0.05,	0.001,	"ms",	"%.0f" },
	{ 0.02,	0.001,	"ms",	"%.0f" },
	{ 0.01,	0.001,	"ms",	"%.0f" },
	{ 0.005,	0.001,	"ms",	"%.0f" },
	{ 0.002,	0.001,	"ms",	"%.0f" },
	{ 0.001,	0.001,	"ms",	"%.0f" },
	{ 0.0005,	0.001,	"ms",	"%.1f" },
	{ 0.0002,	0.001,	"ms",	"%.1f" },
	{ 0.0001,	0.001,	"ms",	"%.1f" },
	{ 0.00005,0.000001,"us",	"%.0f" },
	{ 0.00002,0.000001,"us",	"%.0f" },
	{ 0.00001,0.000001,"us",	"%.0f" },
	{ 0,	0,	"",	"" }
};
	
/* grid points for external access */
int	digit_xgrid[100];	
int	digit_nxgrid;
		
#ifdef __STDC__
int    digitemtime(int32  bundles,float  xl,float    yb,float  xr,float  yt,double  start,double  stop,int  flags)
#else
int digitemtime(bundles,xl,yb,xr,yt,start,stop,flags)
int32	bundles;	/* colours: 10000*divisions + 100*labels + title */
float	xl,yb,xr,yt;	/* x,y co-ords of display */
double	start,stop;	/* start, stop time (seconds) */
int	flags;		/* format flags */
#endif
{
	int	scale,xoff;
	int	ixl,iyb,ixr,iyt,iym,iyl;
	int	tbun,lbun,dbun;
	double	unittime,tenthtime,offset,t,scalex;
	int	x,marks=0;
	char	str[32];

	/* get pixel coordinates of box */
	ixl = xpix(xl);
	iyb = ypix(yb);
	ixr = xpix(xr);
	iyt = ypix(yt);
	if (xr < xl) {
		t = xl;
		xl = xr;
		xr = (float)t;
	}
	if (yt < yb) {
		t = yb;
		yb = yt;
		yt = (float)t;
	}
	/* calc "iym" - top of small markers */
	iym = iyt - digdata.chheight;
	if (iym < iyb) iym = iyb;
	if (iym > (iyt+iyb+iyb)/3) iym = (iyt+iyb+iyb)/3;
	/* calc "iyl" - bottom of lettering */
	iyl = (iyt+iyt+iyb)/3 - digdata.chheight/2;
	if (iyl < iym) iyl = iym;

	/* determine bundles */
	tbun = bundles % 100;
	if (tbun==0) tbun=DEFBUN;
	lbun = (bundles % 10000) / 100;
	if (lbun==0) lbun=DEFBUN;
	dbun = (bundles % 1000000) / 10000;
	if (dbun==0) dbun=DEFBUN;
	
	/* determine size of x-axis offset */
	if (!digdata.setup) return(-1);
	xoff = AXCHAR * digdata.chwidth + 3;

	/* clear box */
	digfillboxp(0,ixl,iyb,ixr,iyt);

	/* draw box if required */
	if (flags & DIGITEMBOX) {
		digboxp(dbun,ixl,iyb,ixr,iyt);
		diglinep(dbun,ixl+xoff,iyb,ixl+xoff,iyt);
	}

	/* determine how many timing markers */
	/* -- go for 1 marker every 12 or so h/w text chars */
	unittime = 12 * digdata.chwidth * (stop - start) / (ixr - ixl - xoff);
	for (scale=0;(timtab[scale].time > 0) && (timtab[scale].time > unittime);scale++) ;
	if (timtab[scale].time==0) return(-1);
	unittime=timtab[scale].time;
	tenthtime=unittime/10;

	/* calculate offset time of scale */
	offset = ((int)(start/unittime))*unittime + unittime - start;
	if (offset>=unittime) offset=0.0;
	marks = 10 - (int)(10*offset/unittime);
	offset = ((int)(start/tenthtime))*tenthtime + tenthtime - start;
	if (offset>=tenthtime) offset=0.0;

	/* display time scale */
	scalex = (double)(ixr - ixl - xoff)/(stop-start);
	stop -= start;
	digit_nxgrid=0;
	for (t = offset; t < stop; t += tenthtime) {
		x = (int)(ixl + xoff + t * scalex);
		if ((marks % 10)==0) {
			diglinep(dbun,x,iyb,x,iyt);
			sprintf(str,timtab[scale].format,(start+t)/timtab[scale].scale);
			if ((int)(x + 3 + digdata.chwidth * strlen(str)) < ixr)
				digtextp(lbun,x+3,iyl,str);
			digit_xgrid[digit_nxgrid++]=x;
		}
		else if ((marks % 10)==5)
			diglinep(dbun,x,iyb,x,(iyb+iyt)/2);
		else
			diglinep(dbun,x,iyb,x,iym);
		marks++;
	}

	/* display units */
	sprintf(str,"Time (%s)",timtab[scale].label);
	digtextp(tbun,ixl+3,(iyt+iyb-digdata.chheight)/2,str);

	return(0);
}

#ifdef EMO
main ()
{

	digstart('\0',NULL,1);
	digscale(100.0,100.0,0);
	digclearscreen();

	digitemtime(222120,0.0,90.0,100.0,100.0,0.0,10.0,1);
	digitemtime(222120,0.0,80.0,100.0,90.0,0.099999,10.0,1);
	digitemtime(222120,0.0,70.0,100.0,80.0,0.10001,10.0,1);
	digitemtime(222120,0.0,60.0,100.0,70.0,1.65,10.2,1);
	digitemtime(222120,0.0,50.0,100.0,60.0,9.5,10.0,1);
	digitemtime(222120,0.0,40.0,100.0,50.0,9.95,10.0,1);
	digitemtime(222120,0.0,30.0,100.0,40.0,9.995,10.0,1);
	digitemtime(222120,0.0,20.0,100.0,30.0,9.9995,10.0,1);
	digitemtime(222120,0.0,13.0,100.0,20.0,0.0,10.0,1);
	digitemtime(222120,0.0,8.0,100.0,13.0,0.0,10.0,1);
	digitemtime(222120,0.0,5.0,100.0,8.0,0.0,10.0,1);
	digitemtime(222120,0.0,0.0,50.0,5.0,0.0,10.0,1);
	digitemtime(222120,50.0,0.0,80.0,5.0,0.0,10.0,1);
	digitemtime(222120,80.0,0.0,100.0,5.0,0.0,10.0,1);

	digend();
}
#endif
