/* DSP routines from Mike Brookes, Imperial College London */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "sfs.h"
#include "libic.h"

#define NAME "exptable"

void exptable(len,table)
int len;
COMPLEX **table;
{
/*
This routine calculates a table of exp(i*PI/len)
for i = 0,1,..,2*len

It probably is unnecessary - a table of sines would do as well
*/

    static int n=0;
    static COMPLEX *tab;
    int i,j,n2;
    COMPLEX *ptab,*plim,*tablim,*qtab;
    REAL theta,s,c,qr,qi;

    if (len == n) {
	*table = tab;
	return;
	}
    if (len <= 0) error("%s: length (= %d) must be >= 0",NAME,len);
    if (n) {
	free(tab);
	}
    n = len;
    n2 =  n/2 + 1;
    tab = (COMPLEX *) malloc((n+n+1)*sizeof(COMPLEX));
    if (!tab) {
	error("%s: cannot allocate space for table (%d bytes)",
		   NAME,   n2*sizeof(COMPLEX));
	}
    if (! (len & 1)) n2 = n/4 + 1;
    tablim = tab + n2;
    
    i = 1;
    j = 2;
    theta = PI/len;
    ptab = tab;
    ptab->r = 1.0;
    (ptab++)->i = 0.0;
    while(ptab < tablim) {
	c = cos(i*theta);
	s = sin(i*theta);
	qtab = ptab;
	plim = i < n2 ? tab+i : tablim;
	while (ptab < plim) {
	    qr = (--qtab)->r;
	    qi = qtab->i;
	    ptab->r = c * qr + s * qi;
	    (ptab++)->i = s * qr - c * qi;
	    } 
	if (ptab < tablim) {
	    ptab->r = c;
	    ptab++->i = s;
	    
	    plim = j < n2 ? tab+j : tablim;
	    while (ptab < plim) {
		qr = qtab->r;
		qi = (qtab++)->i;
		ptab->r = c * qr - s * qi;
		(ptab++)->i = s * qr + c * qi;
		}
	    }
	j += (i *= 3);
	}
    if (! (len & 1)) {		/* fill in other half of table */
	n2 = n/2 + 1;
	ptab = tab + n2;
	qtab = tab - 1;
	while (--ptab > ++qtab) {
	    ptab->r = qtab->i;
	    ptab->i = qtab->r;
	    }
	}
/* Now fill in second quadrant */

    ptab = tab + n +1;
    qtab = tab -1;
    while (--ptab > ++qtab) {
	ptab->r = -qtab->r;
	ptab->i = qtab->i;
	}

/* and finally the last two quadrants */

    ptab = tab + n + n + 1;
    qtab = tab -1;
    while (--ptab > ++qtab) {
	ptab->r =  qtab->r;
	ptab->i = -qtab->i;
	}
	    
    *table = tab;
    return;
    }
#ifdef EMO
main()
{
    int i,j;
    COMPLEX *table;

    for (;;) {
	printf("Enter len: ");
	scanf("%d",&i);
	exptable(i,&table);
	for (j=0; j <= (i+i); j++ ) {
	    printf("%4d: %10g %10g\n",j,table->r,table->i);
	    table++;
	    }
	}
    }
#endif
