/* getline - get a limited length line of input from the terminal */

/*--------------------------------------------------------------------------*/
/**MAN
.TH GETLINE SFS3 UCL SFS
.SH NAME
getline - get a line from the standard input
.SH SYNOPSIS
.nf

char *  getline(buff,len)
char *  buff;
int     len;

.fi
.SH DESCRIPTION
.I getline
is a routine to read a line of input from the standard input, and place it into
.I buff.
A maximum of 
.I len-1
characters are read in, and any remaining characters on the line 
and the terminating '\\n' character is discarded.
.SH DIAGNOSTICS
.I getline
returns
.I buff
on success, and the NULL pointer on end-of-file.
.SH VERSION/AUTHOR
1.0 - Mark Huckvale
*/
/*--------------------------------------------------------------------------*/

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"

/* get line */
char	*getline(s,lim)
char 	*s;
int 	lim;
{
	int	c=0;
	char	*d=s;

	/* get in line, up to "lim" chars */
	while ((--lim > 0) && ((c = getchar()) != EOF) && (c != '\n')) *d++ = c;

	/* skip rest of line */
	if (c != '\n') 
		while (((c = getchar()) != EOF) && (c != '\n')) /* skip */;

	/* put in terminator */
	*d++ = '\0';

	/* return string or EOF code */
	if (c==EOF)
		return(NULL);
	else
		return(s);
}

#ifdef IAG
main()
{
	char	line[5];

	for (;;) {
		printf("Enter up to 5 chars : ");
		fflush(stdout);
		getline(line,5);
		printf("You typed '%s'\n",line);
	}
}
#endif
