/* pathname -- return full pathname of file */

/* m.a.huckvale - december 1986 */
/* C M Ayer - July 1989 (version to run on Sun4 UNIX system) */

/* version 1.1 */

/*--------------------------------------------------------------------------*/
/**MAN
.TH PATHNAME SFS3 MSIS SFS
.SH NAME
pathname - get full pathname of file
.SH SYNOPSIS
.nf

char     *\fBpathname\fR(name)
char     *name;

.fi
.SH DESCRIPTION
.I pathname
is a subroutine to return the full pathname of file.  For pathnames
not beginning with "/", it concatenates "name" with the current
working directory and eliminates strings such as "./" and
"dir/..".  The routine returns a pointer to a static area.
.SH VERSION/AUTHOR
1.2 - Colin Ayer
.SH SEE ALSO
getwd(3), dirname(1), basename(1), sfsfile(SFS3)
*/
/*--------------------------------------------------------------------------*/

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include "sfs.h"

/* forward function prototypes */
#ifdef DOS
static void locase(char *);
#endif

char	*pathname(name)
char	*name;
{
	char		buff[SFSMAXFILENAME];
	char		*ptr[32];
	int		i,j,num=0;
	static char	cwd[SFSMAXFILENAME];

	/* check if relative */
	if ((name[0]=='\\') || (name[0] == '/') || (isalpha(name[0]) && (name[1]==':'))) {
		/* take copy of complete name */
		strcpy(buff,name);
	}
	else {
		/* otherwise .. concatenate with working directory name */
		getcwd(buff,256);
		strcat(buff,"\\");
		strcat(buff,name);
	}

	/* split up into pathname components */
	ptr[0]=strtok(buff,"\\/");
	while (ptr[num] && *(ptr[num])) {
		num++;
		ptr[num]=strtok((char *)0,"\\/");
	}

	/* eliminate unnecessary components */
	for (i=1;i<num;i++) {
		if (strcmp(ptr[i],".")==0)
			ptr[i]=NULL;
		else if (strcmp(ptr[i],"..")==0) {
			j=i-1;
			while ((j>0) && (ptr[j]==NULL)) j--;
			ptr[j]=NULL;
			ptr[i]=NULL;
		}
	}
	
	/* put filepath together again */
	if (ptr[0]) {
		if (ptr[0][1]==':')
			strcpy(cwd,ptr[0]);
		else {
			strcpy(cwd,"/");
			strcat(cwd,ptr[0]);
		}
	}
	else
		strcpy(cwd,"");
	for (i=1;i<num;i++)
		if (ptr[i]) {
			strcat(cwd,"/");
			strcat(cwd,ptr[i]);
		}
	if (cwd[0]=='\0') strcpy(cwd,"/");
	if ((cwd[1]==':') && (cwd[2]=='\0')) strcat(cwd,"/");
	
#ifdef DOS
	/* convert to lower case and return */
	locase(cwd);
#endif
	return(cwd);
}

#ifdef DOS
static void locase(s)
register char	*s;
{
	for (;*s;s++) *s = tolower(*s);
}
#endif

#ifdef IAG
main()
{
	char	filename[80];
	char	*pathname();
	for (;;) {
		printf("Enter file name : ");
		fflush(stdout);
		scanf("%s",filename);
		printf("full pathname=%s\n",pathname(filename));
	}
}
#endif
