/* sfsnitem -- scan file for item headers */

/* version 1.0 - June 1987 */
/* version 1.1 - August 1989 - C M Ayer - sun4 mods */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"
#include "sfsdata.h"

int sfsnextitem(fid,item)
int			fid;		/* file descriptor */
struct item_header 	*item;		/* returned item header */
{
	/* check everything ok */
	if (
	    (sfsdata[fid]==NULL) || 			/* file not opened */
	    (sfsdata[fid]->mode != SFSREAD)		/* not reading it */
		) 
		return(0);

	/* close any old access */
	if (sfsdata[fid]->lfid > 0) {
		sfsclose(sfsdata[fid]->lfid);
		sfsdata[fid]->lfid=0;
	}

	/* check if only need to reposition */
	if (!item) {
		lseek(fid,sizeof(struct main_header),0);
		sfsdata[fid]->item.length=0;
		sfsdata[fid]->datastart=lseek(fid,0L,1);
		sfsdata[fid]->currpos=sfsdata[fid]->datastart;
		sfsdata[fid]->start=0;
		sfsdata[fid]->numf=0;
		sfsdata[fid]->lfid=0;
		sfsdata[fid]->multiplex=0;
		sfsdata[fid]->swab=0;
		sfsdata[fid]->dcoffset=0;
		sfsdata[fid]->shift=0;
		return(1);
	}

	/* check in right place */
	if (sfsdata[fid]->currpos != (sfsdata[fid]->datastart+sfsdata[fid]->item.length))
		lseek(fid,sfsdata[fid]->datastart+sfsdata[fid]->item.length,0);

	/* read next item header */
	if (read(fid,item,sizeof(struct item_header)) !=
	    sizeof(struct item_header))
		return(0);
#if SFS_SWAP_HEADER
	/* always swap into sun4 format */
	sun4swap((int32 *)item);
#endif
	/* convert format if required */
	if (item->machine != SFSMACHINE)
		sfsconvi(item);

	/* keep record */
	sfsdata[fid]->item = *item;
	sfsdata[fid]->datastart = lseek(fid,0L,1);
	sfsdata[fid]->start=0;
	sfsdata[fid]->numf=0;
	sfsdata[fid]->multiplex=0;
	sfsdata[fid]->swab=0;
	sfsdata[fid]->dcoffset=0;
	sfsdata[fid]->shift=0;

	/* seek past data */
	lseek(fid,item->length,1);
	sfsdata[fid]->currpos = lseek(fid,0L,1);

	return(1);
}

#ifdef IAG
main()
{
	char	filename[80];
	struct item_header item;
	int	i=1,fid;

	printf("Enter filename : ");
	fflush(stdout);
	scanf("%s",filename);

	if ((fid=sfsopen(filename,"r",NULL)) < 0) exit(1);

	while (sfsnextitem(fid,&item)) {
		printf("%2d. %3d.%02d %s\n",
			i,
			item.datatype,
			item.subtype,
			item.history);
		i++;
	}
	sfsnextitem(fid,NULL);	/* reposition */
	if (sfsnextitem(fid,&item)) {
		printf("%2d. %3d.%02d %s\n",
			1,
			item.datatype,
			item.subtype,
			item.history);
		i++;
	}
	exit(0);
}
#endif
