/* sylist -- list SY item in Hertz and dB */

/* m.a.huckvale - december 1985 */

/* version 1.1 - feb 86
	- "-a" switch to include annotations in listing
version 1.2 - may 1986
	- Release 1, new format SY
version 2.0 - March 1989
	- SFS version
*/
/*--------------------------------------------------------------------------*/
/**MAN
.TH SYLIST SFS1 UCL 
.SH NAME
sylist - list synthesizer control codes item as text
.SH SYNOPSIS
.B sylist
(-I) (-i item) (-a) file
.SH DESCRIPTION
.I sylist
lists a SY item in Hertz and dB to the standard output.  
An option allows the inclusion of segment boundaries from an annotation item.
.PP
.I Options
and their meanings are:
.TP 11
.B -I
Identify program and exit.
.TP 11
.BI -i item
Select input item type and subtype.
.TP 11
.B -a
Delimit segments in output using annotations.
.SH INPUT ITEMS
.IP SY 11
Any SY item.
.IP AN 11
Optional annotation item
.SH VERSION/AUTHOR
2.0s - Mark Huckvale
.SH SEE ALSO
syout, syload
*/
/*--------------------------------------------------------------------------*/

/* program name and version */
#define	PROGNAME "sylist"
#define PROGVERS "2.0s"
char *progname=PROGNAME;

/* global declarations */
#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"		/* database filing system structures */

/* global data */
struct item_header syitem;	/* filing system item header for sy */
struct item_header anitem;	/* item header for An item */

/* buffers */
short		*sy;
struct an_rec	*an;

/* main program */
void main(argc,argv)
int	argc;
char	*argv[];
{
	/* option decoding */
	extern int	optind;		/* option index */
	extern char	*optarg;	/* option argument ptr */
	int		errflg = 0;	/* option error flag */
	int		annreq=0;	/* annotation not required */
	char		*antype="0";	/* default annotation item = last */
	char		*sytype ="0";	/* default SY item = last */
	int		c;		/* option switch */
	int32		it;		/* item/sub-type specifiers */
	char		*ty;
	/* file variables */
	char		filename[SFSMAXFILENAME];	/* dbase file name */
	int		fid;
	/* processing variables */
	int		i,anidx=0;
	double		sytime;		/* time of current frame */
	double		antime=0;	/* time of annotation */

	/* decode switches */
	while ( (c = getopt(argc,argv,"Ii:a")) != EOF )
		switch (c) {
		case 'I' :	/* Identify */
			fprintf(stderr,"%s: List synthesizer control data V%s\n",PROGNAME,PROGVERS);
			exit(0);
			break;
		case 'a' :	/* annotation required */
			annreq++;
			break;
		case 'i' :	/* specific item */
			if (itspec(optarg,&it,&ty) == 0) {
				if (it == SY_TYPE)
					sytype = ty;
				else if (it == AN_TYPE) {
					antype = ty;
					annreq++;
				}
				else
					error("unsuitable item specifier %s",optarg);
			}
			else
				error("illegal item specifier %s",optarg);
			break;
		case '?' :	/* unknown */
			errflg++;
	}
	/* check for option decoding error */
	if (errflg || (argc<2))
		error("usage: %s (-I) (-a) (-i item) file",PROGNAME);

	/* get filename */
	if (optind < argc)
		strcpy(filename,sfsfile(argv[optind]));
	else
		error("no database file specified",NULL);

	/* load annotation item if required */
	if (annreq)
		getitem(filename,AN_TYPE,antype,&anitem,(void **)&an);

	/* locate SY item */
	if ((fid=sfsopen(filename,"r",NULL)) < 0)
		error("access error on '%s'",filename);
	if (!sfsitem(fid,SY_TYPE,sytype,&syitem))
		error("cannot find input SY item in '%s'",filename);

	/* allocate SY buffer */
	if ((sy=(short *)sfsbuffer(&syitem,1))==NULL)
		error("cannot allocate SY buffer",NULL);

	/* list data */
	printf("*  fx   f1   a1   f2   a2   f3   a3   f4   a4   fn   an    v\n");
	if (annreq) {
		antime = anitem.offset + an[anidx].posn * anitem.frameduration;
	}
	sytime=syitem.offset;
	for (i=0;sfsread(fid,i,1,sy);i++) {
		sytime += syitem.frameduration;
		while ((annreq) && (antime < sytime) && (anidx<anitem.numframes-1)) {
			printf("%s\n",an[anidx].label);
			antime = anitem.offset + an[++anidx].posn * anitem.frameduration;
		}
		printf("%5d",sy[0]);
		printf("%5d%5.1f",sy[3],sy[4]/10.0);
		printf("%5d%5.1f",sy[6],sy[7]/10.0);
		printf("%5d%5.1f",sy[9],sy[10]/10.0);
		printf("%5d%5.1f",sy[12],sy[13]/10.0);
		printf("%5d%5.1f",sy[15],sy[16]/10.0);
		printf("%5d\n",sy[18]);
	}

	/* and exit */
	sfsclose(fid);
	exit(0);
}

