/* dspcerr - merge error lines with C++ source */

/* M.A.Huckvale - University College London - September 1991 */

#define PROGNAME "dspcerr"
#define PROGVERS "1.0"
char *progname=PROGNAME;

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>

/* memory to hold sorted error messages */
#define MAXERR	100
struct err_rec {
	int32	linecol;	/* combined line and column (16+16 bits) */
	char	*errmsg;	/* dynamic message */
} errtab[MAXERR];
int	numerr;

char	iline[1024];

void error(s,t)
char *s,*t;
{
	extern char *progname;
	fprintf(stderr,"%s: ",progname);
	fprintf(stderr,s,t);
	fprintf(stderr,"\n");
	exit(1);
}

/* duplicate a string in dynamic memory */
char *strsave(str)
char	*str;
{
	char	*ptr;

	if ((ptr=malloc(strlen(str)+1))==NULL)
		error("out of memory");
	strcpy(ptr,str);
	return(ptr);
}

/* look for a filename embedded in a string */
char *strcontains(substr,str)
char	*substr;
char	*str;
{
	char	*p,*q;

	while (*str) {
		p=substr;
		q=str;
		while (*p && (toupper(*p)==toupper(*q))) {
			p++;
			q++;
		}
		if (!*p) {
			return(q);
		}
		str++;
	}
	return(NULL);
}
		
/* scan an error message for file, line, col and messg */
int scanerr(sfname,iline,err)
char	*sfname;
char	*iline;
struct err_rec *err;
{
	char	*p;
	int	line=0,col=0;

	if ((p=strcontains(sfname,iline))) {
		while (isspace(*p) || ispunct(*p) || (*p=='(')) p++;
		if (isdigit(*p)) {
			/* got a line number */
			while (isdigit(*p)) {
				line = 10*line + *p -'0';
				p++;
			}
			while ((*p!=')') && (isspace(*p) || ispunct(*p)) && (*p!='`')) p++;
			if (isdigit(*p)) {
				/* got a column number */
				while (isdigit(*p)) {
					col = 10*col + *p -'0';
					p++;
				}
			}
			while (isspace(*p) || ispunct(*p) || (*p==')')) p++;
			err->linecol = ((int32)line) << 16 | col;
			err->errmsg = strsave(strtok(p,"\n"));
			return(1);
		}
	}
	return(0);
}

/* load error lines from file */
void loaderrlines(sfname,efname)
char	*sfname;	/* source file name */
char	*efname;	/* error file name */
{
	FILE		*ip;
	struct err_rec 	err;
	int		cerr;

	/* open error file */
	if ((ip=fopen(efname,"r"))==NULL)
		error("unable to open error file '%s'",efname);

	/* scan error file */
	while ((numerr < MAXERR) && fgets(iline,1024,ip)) {
		/* look for matching error lines */
		if (scanerr(sfname,iline,&err)) {
			/* put lines in sorted order */
			cerr=numerr;
			while ((cerr > 0) && (errtab[cerr-1].linecol > err.linecol)) {
				errtab[cerr] = errtab[cerr-1];
				cerr--;
			}
			errtab[cerr]=err;
			numerr++;
		}
	}

	fclose(ip);
}

/* main program */
void main(argc,argv)
int	argc;
char	*argv[];
{
	extern int 	optind;
	int		c,errflg=0;
	
	char	sfilename[80];	/* source filename */
	char	bfilename[80];	/* source backup filename */
	char	tfilename[80];	/* temporary filename */
	FILE	*ip;		/* input file descriptor */
	FILE	*op;		/* output file descriptor */
	int	cerr,col;
	int32	lno;
	char	*p;

	while ((c=getopt(argc,argv,"I"))!=EOF) switch (c) {
	case 'I':	/* Identify */
		fprintf(stderr,"%s: Merge DSPC errors into source Vs%s\n",
			PROGNAME,PROGVERS);
		exit(0);
	default:
		errflg++;
	}
	if (errflg || (argc < 2))
		error("usage: %s (-I) source.spc (list.err ...)",PROGNAME);

	/* get source filename */
	if (optind < argc)
		strcpy(sfilename,argv[optind]);
	else
		error("no source file given");

	/* make back-up file name */
	strcpy(bfilename,sfilename);
	if ((p=strrchr(bfilename,'.')))
		strcpy(p,".bak");
	else
		strcat(bfilename,".bak");
	if (strcmp(sfilename,bfilename)==0)
		error("could not create backup file for '%s'",sfilename);

	/* load error lines */
	for (optind++;optind<argc;optind++)
		loaderrlines(sfilename,argv[optind]);

	/* move source file to backup */
	if (access(sfilename,6)!=0)
		error("unable to find source file '%s'",sfilename);
	unlink(bfilename);
	if (rename(sfilename,bfilename)!=0)
		error("unable to save source file as '%s'",bfilename);

	/* open source file */
	if ((ip=fopen(bfilename,"r"))==NULL)
		error("unable to open source file '%s'",bfilename);

	/* open temporary file */
	strcpy(tfilename,"tmXXXXXX");
	mktemp(tfilename);
	if ((op=fopen(tfilename,"w"))==NULL)
		error("unable to create temporary file '%s'",tfilename);

	/* OK, copy across, merging in lines */
	lno=1;
	cerr=0;
	while (fgets(iline,1024,ip)) {
		if (strncmp(iline,"//$ERR",5)!=0)
			fputs(iline,op);
		while ((cerr < numerr) && (lno==(errtab[cerr].linecol >> 16))) {
			col = errtab[cerr].linecol & 0xFFFFL;
			fputs("//$ERR",op);
			if (col) {
				col -= 5;
				while (col-- > 0) putc(' ',op);
				putc('^',op);
			}
			else
				putc(' ',op);
			fputs(errtab[cerr].errmsg,op);
			fputs("\n",op);
			cerr++;
		}
		lno++;
	}

	fclose(ip);
	fclose(op);

	/* done, rename */
	if (rename(tfilename,sfilename)!=0)
		error("unable to rename temporary file '%s'",tfilename);

	exit(0);
}

