// lpcsolve.h -- definitions for linear equation

class Equation {
private:
	int	ncol;
	double	*col;
public:
	int ncols(void) const { return ncol; };
	Equation(void) {
		ncol = 100;		// yuk hack
		col = new double [ncol];
	};
	Equation(int nc) {
		ncol = nc+2;
		col = new double [ncol];
	};
	~Equation() {
		delete [] col;
	};
	Equation (const Equation& ieq) {
		ncol = ieq.ncols();
		col = new double [ncol];
		for (int j=0;j<ncol;j++)
			col[j] = ieq[j];
	};
	Equation& Equation::operator= (const Equation& ieq) {
		if (&ieq == this)
			return *this;
		ncol = ieq.ncols();
		col = new double [ncol];
		for (int j=0;j<ncol;j++)
			col[j] = ieq[j];
		return *this;
	};
	double& operator[] (const int idx) { return col[idx]; };
	const double& operator[] (const int idx) const { return col[idx]; };
};

int	LPCSolve(
	Waveform x,		// windowed input signal
	int order,		// predictor order required
	LTISystem& ltis		// returned predictor coefficients
	);			// returns 0=OK, 1=zero power, 2=fail

