// ltisysch.h -- LTI System Chain class definitions
//
// C++ (c) 1996 Mark Huckvale University College London

#include "tools.h"
#include "ltisysch.h"

// constructors
LTISystemChain::LTISystemChain(int n)
{
	nsection = n;
	section = new LTISystem[n];
}
LTISystemChain::LTISystemChain(const LTISystemChain& lch)
{
	nsection = lch.nsection;
	section = new LTISystem[nsection];
	for (int i=0;i<nsection;i++)
		section[i] = lch.section[i];
}
LTISystemChain::~LTISystemChain()
{
	delete [] section;
}

// assignment
LTISystemChain& LTISystemChain::operator= (const LTISystemChain& lch)
{
	if (&lch == this) return *this;
	delete [] section;
	nsection = lch.nsection;
	section = new LTISystem[nsection];
	for (int i=0;i<nsection;i++)
		section[i] = lch.section[i];
	return *this;
}
LTISystem& LTISystemChain::operator[] (int idx)
{
	static LTISystem junk;
	if ((idx < 0) || (idx >= nsection))
		return junk;
	else
		return section[idx];
}

// clear system
void LTISystemChain::clear()
{
	for (int i=0;i<nsection;i++) section[i].clear();
}

// run system
double LTISystemChain::operator() (double ival)
{
	if (nsection==0) return 0.0;
	for (int i=0;i<nsection;i++) ival = section[i](ival);
	return ival;
}

// frequency response
Complex LTISystemChain::response(double freq) const
{
	if (nsection==0) return Complex(0.0,0.0);
	Complex resp = section[0].response(freq);
	for (int i=1;i<nsection;i++) resp *= section[i].response(freq);
	return resp;
}
