// noise.cpp -- generate noise samples
//
// 	SampleNoise()	generate samples from white noise source
//
// C++ (c) 1996 Mark Huckvale University College London

#include <stdlib.h>
#include "noise.h"

#ifdef _MSC_VER

/* random number generator for MSC */

static unsigned int seed=123456789;

#define a      16807          /* 7^5 */
#define m      2147483647     /* 2^31 - 1*/
#define q      127773         /* m/a */
#define r      2836           /* m%a */

void srandom(int newseed)
{
	seed = newseed;
}

int random(void)
{
	int tmp_seed;

	tmp_seed = a * ( seed % q ) - r * (seed / q );
	if( tmp_seed >= 0)
		seed = tmp_seed;
	else
		seed = tmp_seed + m;

	return(seed);
}
#endif

double	SampleNoise(
	double amp	// peak amplitude
	)		// returns noise sample
{
	// average 6 uniform distribution random numbers
	//   to approximate gaussian amplitude distribution
	double sum=0;
	for (int i=0;i<6;i++)
		// add in random numbers -1.0 .. +1.0
		sum += (random()%1000000)/500000.0 - 1.0;

	// return scaled sample
	return amp * sum / 6;
}
