// waveform.h -- definition for Waveform (real waveform) class
//
// (c) 1996 Mark Huckvale University College London

// The Waveform class provides a basic set of functions for
// manipulating real-valued signals for DSP

#ifndef __Waveform_H
#define __Waveform_H

#include "wavedoub.h"

class Waveform : public WaveDouble {
public:
	// constructors + assignment
	Waveform(int size=1,double srate=20000) : WaveDouble(size,srate,1) {};
	Waveform(const WaveDouble& isig) : WaveDouble(isig) {};
	Waveform& operator=(const WaveDouble& isig)
	{
		WaveDouble::operator=(isig);
		return *this;
	}
	// specialised functions
	void plot(Graph& gr,int gno,const char *pt=0,const char *xt=0,const char *yt=0) const
	{
		WaveDouble::plot(gr,gno,(pt)?pt:"Waveform",
			(xt)?xt:"Time (s)",(yt)?yt:"Amp (V)");
	};
};
#endif
