// window.cpp -- Hamming window functions
//
// C++ (c) 1996 Mark Huckvale University College London

#include "tools.h"
#include "window.h"

// apply hamming window to a waveform
Waveform Hamming(const Waveform& iwv)
{
	Waveform owv(iwv.count(),iwv.rate());
	double omega = 2.0 * PI / (iwv.count()-1);

	for (int i=1;i<=owv.count();i++)
		owv[i] = (0.54 - 0.46 * cos(omega*(i-1))) * iwv[i];

	return owv;
}

// apply hamming window to a complex waveform
ComplexWaveform Hamming(const ComplexWaveform& iwv)
{
	ComplexWaveform owv(iwv.count(),iwv.rate());
	double omega = 2.0 * PI / (iwv.count()-1);

	for (int i=1;i<=owv.count();i++)
		owv[i] = (0.54 - 0.46 * cos(omega*(i-1))) * iwv[i];

	return owv;
}

