{ wave.inc -- Speech Pascal waveform manipulation functions 1.0 }

{ create a new waveform }
external function NewWaveform(wv_size:integer;wv_rate:real):waveform;

{ cut a part out of a waveform }
external function CutWaveform(var wv_signal:waveform;
				first_sample,last_sample:integer):waveform;

{ replay a waveform - really a SFS library function }
external procedure ReplayWaveform(var wv_signal:waveform);

{ record a waveform - really a SFS library function }
external function RecordWaveform(wv_size:integer;wv_rate:real):waveform;

{ pause }
external procedure Pause(num_sec:real);

function SampleCount(var wv:waveform):integer;
begin
	SampleCount := wv._size;
end;

function SampleRate(var wv:waveform):real;
begin
	SampleRate := wv._rate;
end;

{ convert to/from realwave }
function ConvertWaveReal(var wv:waveform):realwave;
var
	i:integer;
	rwv:realwave;
begin
	i:=0;
	while (i<wv._size) and (i<REALWAVESIZE) do begin
		rwv[i+1] := wv[i];
		i := i + 1;
	end;
	while (i<REALWAVESIZE) do begin
		rwv[i+1] := 0;
		i := i + 1;
	end;
	ConvertWaveReal := rwv;
end;

function ConvertRealWave(var rwv:realwave;size:integer;rate:real):waveform;
var
	i:integer;
	wv:waveform;
begin
	wv := NewWaveform(size,rate);
	for i:=1 to size do begin
		if (rwv[i] < -MAXSHORT) then
			wv[i-1] := -MAXSHORT
		else if (rwv[i] > MAXSHORT) then
			wv[i-1] := MAXSHORT
		else
			wv[i-1] := trunc(rwv[i]);
	end;
	ConvertRealWave := wv;
end;

{ convert to/from complexwave }
function ConvertWaveComplex(var wv:waveform):complexwave;
var
	i:integer;
	cwv:complexwave;
begin
	i:=0;
	while (i<wv._size) and (i<REALWAVESIZE) do begin
		cwv[i+1].re := wv[i];
		cwv[i+1].im := 0;
		i := i + 1;
	end;
	while (i<REALWAVESIZE) do begin
		cwv[i+1].re := 0;
		cwv[i+1].im := 0;
		i := i + 1;
	end;
	ConvertWaveComplex := cwv;
end;

function ConvertComplexWave(var cwv:complexwave;size:integer;rate:real):waveform;
var
	i:integer;
	wv:waveform;
begin
	wv := NewWaveform(size,rate);
	for i:=1 to size do begin
		if (cwv[i].re < -MAXSHORT) then
			wv[i-1] := -MAXSHORT
		else if (cwv[i].re > MAXSHORT) then
			wv[i-1] := MAXSHORT
		else
			wv[i-1] := trunc(cwv[i].re);
	end;
	ConvertComplexWave := wv;
end;

{ convert realwave to/from complexwave }
function ConvertRealComplex(var rwv:realwave;len:integer):complexwave;
var
	i:integer;
	cwv:complexwave;
begin
	for i:=1 to len do begin
		cwv[i].re := rwv[i];
		cwv[i].im := 0;
	end;
	for i:=len+1 to REALWAVESIZE do begin
		cwv[i].re := 0;
		cwv[i].im := 0;
	end;
	ConvertRealComplex := cwv;
end;

function ConvertComplexReal(var cwv:complexwave;len:integer):realwave;
var
	i:integer;
	rwv:realwave;
begin
	for i:=1 to len do
		{ copy over magnitude of complex value }
		rwv[i] := sqrt(cwv[i].re*cwv[i].re+cwv[i].im*cwv[i].im);
	for i:=len+1 to REALWAVESIZE do
		rwv[i] := 0;
	ConvertComplexReal := rwv;
end;

