/* mcnemar -- program to calculate mcnemar statistics */

#include <stdio.h>
#include <string.h>

int getmatch(FILE *ip,char *in,char *out)
{
	char	line[128];
	char	*p;
	
	if (!fgets(line,128,ip)) return(0);
	p = strtok(line," \t\n");
	*in = '\0';
	*out = '\0';
	if (p && *p) strncpy(in,p,79);
	p = strtok(NULL," \t\n");
	if (p && *p) strncpy(out,p,79);
	if (*in && *out)
		return(1);
	else
		return(0);
}

void main(int argc,char **argv)
{
	FILE	*ip1,*ip2;
	int	i,cnt;
	int	yy=0,yn=0,ny=0,nn=0;
	char	in1[80],out1[80];
	char	in2[80],out2[80];

	cnt = (argc-1)/2;
	for (i=0;i<cnt;i++) {
		if ((ip1=fopen(argv[1+i],"r"))==NULL) {
			fprintf(stderr,"Could not open '%s'\n",argv[1+i]);
			exit(1);
		}
		if ((ip2=fopen(argv[1+i+cnt],"r"))==NULL) {
			fprintf(stderr,"Could not open '%s'\n",argv[1+i+cnt]);
			exit(1);
		}
		while (getmatch(ip1,in1,out1)) {
			if (!getmatch(ip2,in2,out2)) {
				fprintf(stderr,"Mismatch in files '%s' and '%s'\n",
					argv[1+i],argv[1+i+cnt]);
				exit(1);
			}
			if (strcmp(in1,in2)!=0) {
				fprintf(stderr,"Mismatch in files '%s' and '%s'\n",
					argv[1+i],argv[1+i+cnt]);
				exit(1);
			}
			if (strcmp(in1,out1)==0) {
				if (strcmp(in2,out2)==0)
					yy++;
				else
					yn++;
			}
			else {
				if (strcmp(in2,out2)==0)
					ny++;
				else
					nn++;
			}
		}
		fclose(ip1);
		fclose(ip2);
	}

	printf("Inputs:        A - B\n");
	for (i=0;i<cnt;i++)
		printf("%16s - %-16s\n",argv[1+i],argv[1+i+cnt]);

	printf("\n");
	printf("              +-------------+-------------+\n");
	printf("  Contingency |  Correct B  | Incorrect B |\n");
	printf("+-------------+-------------+-------------+\n");
	printf("|   Correct A |%10d   |%10d   |\n",yy,yn);
	printf("+-------------+-------------+-------------+\n");
	printf("| Incorrect A |%10d   |%10d   |\n",ny,nn);
	printf("+-------------+-------------+-------------+\n");
	printf("\n");
	printf("Total matches: %d\n",yy+yn+ny+nn);
	exit(0);
}


#if 0
#define MAXFACT	100

double factorial[MAXFACT]={1};

main()
{
	int	i;
	int	ab,ba,n;
	double	p;

	for (i=1;i<MAXFACT;i++)
		factorial[i] = i * factorial[i-1];

	printf("Enter Correct 1/Incorrect 2 : ");
	scanf("%d",&ab);
	printf("Enter Incorrect 1/Correct 2 : ");
	scanf("%d",&ba);
	n = ab+ba;

	p = 0;
	for (i=0;(i<=ab) && (i<=ba);i++)
		p += (factorial[n]/(factorial[i]*factorial[n-i]))/4.0;

	printf("n=%d ab=%d ba=%d p=%g 1/p=%g\n",n,ab,ba,p,1/p);
}

#endif
