{ sptest -- test SFS Speech functions }
program sptest;
var
	fname:string;
	wv:waveform;
	i,splen:integer;
	rwv:waveform;

{$I tools.inc }

begin
	write ('Enter SFS filename: ');
	readln(fname);
	if not SFSFile(fname) then
		writeln(fname,' is not an SFS file.')
	else if not SFSItem('sp') then
		writeln(fname,' does not contain a Speech item.')
	else begin
		write(fname,' has Speech item of ');
		write(SpeechSize:1,' frames at ');
		write(SpeechRate:6:0,'Hz., ');
		writeln('that sounds like this -');
		wv := SpeechLoad;
		ReplayWaveform(wv);
		writeln('The second half was - ');
		wv := SpeechPart(SpeechSize div 2,SpeechSize - 1);
		ReplayWaveform(wv);
		writeln('The first half was - ');
		wv := SpeechPart(0,SpeechSize div 2);
		ReplayWaveform(wv);
		writeln('The middle half was - ');
		wv := SpeechLoad;
		wv := CutWaveform(wv,SpeechSize div 4,3 * SpeechSize div 4);
		ReplayWaveform(wv);
		writeln('And backwards is - ');
		splen := SpeechSize;
		rwv := NewWaveform(splen,SpeechRate);
		for i:=0 to splen-1 do
			rwv._data[i] := wv._data[splen - i - 1];
		ReplayWaveform(rwv);
		writeln('Now backwards and forwards -');
		wv := rwv + SpeechLoad;
		ReplayWaveform(wv);		
	end;
end.
