/* spc.h - header file for SPC */

#define YYDEBUG 1

/* Mark Huckvale - University College London - April 1991 */

#define PROGNAME "spc"
#define PROGVERS "1.0"

/* symbol table */
typedef struct Symrec {
	char	*name;		/* symbol name */
	char	*cname;		/* 'C' version of name */
	short	type;		/* symbol type */
	short	status;		/* symbol status */
	short	etype;		/* expression type */
	short	btype;		/* base expression type (for arrays) */
	struct Symrec *basesym[3];	/* base offset (for arrays) */
	char	*ptype;		/* parameter types (for functions) */
	struct Symrec *next;	/* link */
} Symbol;

#define YYSTYPE Symbol *

/* values for symbol status */
#define RESERVED   0
#define UNDECLARED 1
#define ADRPAR     2
#define VALPAR     3
#define LOCAL      4
#define GLOBAL     5
#define BLTIN      6
#define CONSTANT   7
#define VARPARAM   0x40

/* expression types */
#define EXPNULT ((Symbol *)-2)
#define EXPNULV ((Symbol *)-1)
#define EXPINT	((Symbol *)1)
#define EXPREAL	((Symbol *)2)
#define EXPBOOL ((Symbol *)3)
#define EXPCHAR	((Symbol *)4)
#define EXPSTR	((Symbol *)5)
#define EXPADDR ((Symbol *)6)
#define EXPFILE	((Symbol *)7)
#define EXPWAVE	((Symbol *)8)
#define EXPPTR  ((Symbol *)9)

/* compiler symbols */
#include "spctab.h"

/* prototypes */
#ifdef __STDC__
/* sml.y */
int translate(char *pasf,char *cf,char *errf);
void concat(char *sf1,char *sf2,char *df);
void printfile(char *fname);
void yyerror(char *s);
int parsefail(char *s,YYLTYPE *yylloc);
int warning(YYLTYPE *yylloc,char *s,char *t);
void spcerror(char *s,char *t);
/* spclex.c */
char *strsave(char *str);
Symbol *installsymbol(char *name,short type,short status);
void freesymbol(Symbol *sym);
Symbol *dupsymbol(Symbol *osym);
void symblockstart(void);
void symblockinit(void);
void symblockend(void);
void symblockcancel(void);
int symblockcheck(Symbol *sym1,Symbol *sym2);
void initsymbol(void);
Symbol	*lookupsymbol(char *name);
void resetlex(void);
char *findfile(char *name);
void pushfcontext(char *fname);
int popfcontext(void);
int charget(void);
void charunget(int c);
int yylex(void);
int backslash(int c);
int follow(int c2,int expect,int ifyes,int ifno);
void setvaretype(int itype,int etype,int btype,Symbol **bsym);
void outputnullvar(int itype,char *typename);
void addparamtype(Symbol *sym,int pno,int pty);
void setparamtype(Symbol *sym,int p1,int p2,int pty);
int getparamtype(Symbol *sym,int pno);
/* output.c */
void outputoff(void);
void outputon(void);
void pushoutputbuffer(void);
void popoutputbuffer(void);
void killoutputbuffer(void); 
void swapoutputbuffer(void);
void rot3outputbuffer(void);
void outputstr(char *s);
void output(char *str);
void outputint(int val);
void outputcstring(char *str);
void fileline(int lineno);
void procomment(char *title);
void comment(char *fmt,...);





#endif
