{ sinewave -- function to generate a sine waveform }

function sinewave(
          size:integer;    { # samples required }
          rate:real;       { sampling frequency }
          freq:real        { sinewave frequency }
          ):waveform;
const
     scale=2000.0;         { sine waveform amplitude }
var
     wv:waveform;          { to hold waveform }
     period:real;          { to hold #samples/period }
     i:integer;            { to count through size }
begin
     { generate waveform of supplied size }
     wv := NewWaveform(size,rate);

     { calculate sinewave period in samples }
     period := rate/freq;

     { form sine waveform samples }
     for i:=0 to size-1 do
          wv._data[i] := round(scale *
                            sin(2.0*pi*i/period));

     { return waveform }
     sinewave := wv;
end;
