/* plotover -- test plotting of one graph on top of another */

/* generate some pseudo-random numbers 0.0-1.0 */
function var random()
var hold
{
	hold = (hold*10)+10
	hold = exp(hold)
	hold = hold - trunc(hold)
	return(hold)
}

/* gaussian function */
function var gaussian(n,x)
{
	stat	n
	var	x

	return(exp(-(x-n.mean)*(x-n.mean)/(2*n.variance))/(sqrt(2.0*3.14159)*n.stddev))
}

/* histogram */
var hist[0:100]

/* gaussian curve */
var curve[0:100]

init {
	var	i,j,k
	stat	s

	for (j=1;j<=12000;j=j+1) {
		i = trunc(100*random())
		hist[i] = hist[i]+1
	}

	plottitle(stdout,"Overlaying of Graphs Test")
	plotparam("horizontal=2")
	plotparam("vertical=2")
	plotparam("yzero=yes")
	plotparam("box=yes")
	plotparam("title=Uniform Distribution")
	plot(stdout,1,hist,100)

	clear(hist)
	for (j=1;j<=2000;j=j+1) {
		i=0
		for (k=1;k<=6;k=k+1) i = i + 100*random()
		i = trunc(i/6)
		hist[i] = hist[i] + 1
		s += i
	}
	plotparam("title=Gaussian Distribution")
	plot(stdout,2,hist,100)

	for (j=0;j<=100;j=j+1) curve[j] = 2000*gaussian(s,j)
	plotparam("title=Gaussian Model")
	plot(stdout,3,curve,100)

	plotparam("title=Combined")
	plot(stdout,4,hist,100)
	plot(stdout,4,curve,100)
}
