{ chunkrev -- reverse speech waveform in decreasing chunk size }
program chunkrev;
const
	minchunk = 0.010;	{ 10ms minimum }
var
	fname:string;
	spdur,chunkdur:real;
	sp:waveform;

{$I tools.inc }

procedure replayreverse(wv:waveform;revdur:real);
var
	i,tmp:integer;
	lo,hi:integer;
	revsize:integer;
begin
	revsize := round(revdur * wv._rate);
	lo:=0;
	hi:=revsize-1;

	while hi < wv._size do begin
		for i:=0 to revsize div 2 do begin
			tmp := wv._data[lo+i];
			wv._data[lo+i] := wv._data[hi-i];
			wv._data[hi-i] := tmp;
		end;
		lo := lo + revsize;
		hi := hi + revsize;
	end;

	ReplayWaveform(wv);
end;

begin
	writeln('Enter SFS filename: ');
	readln(fname);
	if not SFSFile(fname) then
		writeln(fname,' is not an SFS file.')
	else if not SFSItem('sp') then
		writeln(fname,' does not contain a Speech item.')
	else begin
		sp := SpeechLoad;
		spdur := SpeechSize / SpeechRate;
		chunkdur := spdur;
		while chunkdur > minchunk do begin
			writeln('Chunk size = ',chunkdur:10:3,'s.');
			replayreverse(sp,chunkdur);
			chunkdur := chunkdur/2.0;
		end;
	end;
end.

