/* symbol - symbol manipulation routines for SML */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sml.h"
#ifdef DOS
#include "y_tab.h"
#else
#include "y.tab.h"
#endif

/* symbol table lookup */
int lookup(s)
char *s;	/* symbol */
{
	register int	i;
	register struct Symrec *sptr;
	register int	lo,mid,hi,match;

/* 
	sptr = &stab[1];
	for (i=1;i<=symreserve;i++) {
		if ((sptr->name != NULL) && 
		    (sptr->vtype != CLEARED) &&
		    (strcmp(sptr->name,s) == 0))
			return(i);
		sptr++;
	}
*/
	/* binary chop on reserved words */
	lo=1; hi=symreserve+1; mid = (lo+hi)/2;
	while (mid > lo) {
		match = strcmp(s,stab[mid].name);
		if (match==0)
			return(mid);
		else if (match < 0)
			hi = mid;
		else
			lo = mid;
		mid = (lo+hi)/2;
	}
	if (strcmp(stab[mid].name,s) == 0) return(mid);

	/* linear search backwards through user symbols */
	sptr = &stab[scnt];
	for (i=scnt;i>symreserve;i--) {
		if ((sptr->name != NULL) && 
		    (sptr->vtype != CLEARED) &&
		    (sptr->name[0] == s[0]) &&
		    (strcmp(sptr->name,s) == 0))
			return(i);
		sptr--;
	}
	return(0);
}

/* symbol table install */
int install(s,ty,vl)
char	*s;	/* name */
int	ty;	/* type */
double	vl;	/* value */
{
	char	*Malloc();
	scnt++;
	stab[scnt].name = Malloc(strlen(s)+1);	/* +1 for '\0' */
	strcpy(stab[scnt].name,s);
	stab[scnt].type = ty;
	stab[scnt].stat = UNDECLARED;
	stab[scnt].vtype = NOTYPE;
	stab[scnt].lo = 0;
	stab[scnt].hi = 0;
	stab[scnt].u.val = vl;
	return(scnt);
}

/* install dummy symbol */
void dummysym()
{
	int	s;
	s=install("",BLOCK,0.0);
	stab[s].u.entry=(int *)NULL;
}

/* dump symbol table */
extern int startnew;
void dumpstab()
{
	int	i;
	for (i=(startnew==0)?1:startnew; i<=scnt; i++) {
		printf("%3d) %-15s ",i,stab[i].name);
		switch (stab[i].type) {
		case VARTOK:	printf("VARTOK    "); break;
		case STATTOK:	printf("STATTOK   "); break;
		case FILETOK:	printf("FILETOK   "); break;
		case STRINGTOK:	printf("STRINGTOK "); break;
		case INIT:	printf("INIT      "); break;
		case MAIN:	printf("MAIN      "); break;
		case SUMMARY:	printf("SUMMARY   "); break;
		case FUNCTOK:	printf("FUNCTOK   "); break;
		case RETURNTOK:	printf("RETURNTOK "); break;
		case IFTOK:	printf("IFTOK     "); break;
		case ELSETOK:	printf("ELSETOK   "); break;
		case WHILETOK:	printf("WHILETOK  "); break;
		case FORTOK:	printf("FORTOK    "); break;
		case PRINTTOK:	printf("PRINTTOK  "); break;
		case INPUTTOK:	printf("INPUTTOK  "); break;
		case FIELD:	printf("FIELD     "); break;
		case WITHTOK:	printf("WITHTOK   "); break;
		case WITHNTOK:	printf("WITHNTOK  "); break;
		case WITHINTOK:	printf("WITHINTOK "); break;
		case CLEARTOK:	printf("CLEARTOK  "); break;
		case ABORTTOK:	printf("ABORTTOK  "); break;
		case LOBOUNDTOK:printf("LOBOUNDTOK"); break;
		case HIBOUNDTOK:printf("HIBOUNDTOK"); break;
		case LIBTOK:	printf("LIBTOK    "); break;
		case NUMBER:	printf("NUMBER    "); break;
		case STRING:	printf("STRING    "); break;
		case DUMMYPAR:	printf("DUMMYPAR  "); break;
		case VAR:	printf("VAR       "); break;
		case STATVAR:	printf("STATVAR   "); break;
		case STRVAR:	printf("STRVAR    "); break;
		case FILEVAR:	printf("FILEVAR   "); break;
		case ARRAY:	printf("ARRAY     "); break;
		case STATARRAY:	printf("STATARRAY "); break;
		case STRARRAY:	printf("STRARRAY  "); break;
		case FUNCTION:	printf("FUNCTION  "); break;
		case SFUNCTION:	printf("SFUNCTION "); break;
		case UNDEF:	printf("UNDEF     "); break;
		case BLOCK:	printf("BLOCK     "); break;
		default:	printf("type %3d, ",stab[i].type);
		}
		printf(" ");
		switch (stab[i].stat) {
		case RESERVED:	printf("RESERVED  "); break;
		case UNDECLARED:printf("UNDECLARED"); break;
		case ADRPAR:	printf("ADRPAR    "); break;
		case VALPAR:	printf("VALPAR    "); break;
		case LOCAL:	printf("LOCAL     "); break;
		case GLOBAL:	printf("GLOBAL    "); break;
		case BLTIN:	printf("BLTIN     "); break;
		default:	printf("stat %d,",stab[i].stat); 
		}
		printf(" ");
		switch (stab[i].vtype) {
		case COUNT:	printf("COUNT   "); break;
		case SUM:	printf("SUM     "); break;
		case SUMSQ:	printf("SUMSQ   "); break;
		case MEAN:	printf("MEAN    "); break;
		case VARIANCE:	printf("VARIANCE"); break;
		case STDDEV:	printf("STDDEV  "); break;
		case NOTYPE:	printf("NOTYPE  "); break;
		case BADFIL:	printf("BADFIL  "); break;
		case CLEARED:	printf("CLEARED "); break;
		default:	printf("pc=%3d, ",stab[i].vtype); 
		}
		printf("lo=%3d, hi=%3d\n",stab[i].lo,stab[i].hi);
	}
}

/* set proper variable types */
void settype(entry,t,g)
int	entry;
int	t,g;
{
	stab[entry].type=t;
	stab[entry].stat=g;
	if (t==FILEVAR)
		stab[entry].vtype = BADFIL;
}

void setarrtype(entry,lonum,hinum,t,g)
int	entry;
int	lonum,hinum,t,g;
{
	stab[entry].lo=(int)stab[lonum].u.val;
	stab[entry].hi=(int)stab[hinum].u.val;
	if (stab[entry].lo > stab[entry].hi) {
		warning("illegal array limits",stab[entry].name);
		stab[entry].lo=1;
		stab[entry].hi=1;
	}
	stab[entry].stat=g;
	if (t==VAR) {
		stab[entry].type=ARRAY;
	}
	else if (t==STRVAR) {
		stab[entry].type=STRARRAY;
	}
	else if (t==STATVAR) {
		stab[entry].type=STATARRAY;
	}
	else
 		warning("funny array declaration",stab[entry].name);
}

/* set function type */
void setfunctype(ent,t,loc)
int	ent,loc;
int	t;
{
	stab[ent].type=t;
	stab[ent].stat=GLOBAL;
	stab[ent].vtype=loc;
	stab[ent].u.entry=(int *)NULL;
}

/* set up variable block */
void setblock(entry)
int	entry;
{
	stab[entry].lo=entry+1;
	stab[entry].hi=scnt;
}

/* clear local variables */
void clearlocals()
{
	int	i;
	for (i=0;i<=scnt;i++) 
		if ((stab[i].stat==LOCAL) || (stab[i].stat==ADRPAR) || (stab[i].stat==VALPAR)) {
			stab[i].vtype = CLEARED;
	}
}

/* check functions parameters */
void checkpars()
{
	int	first,last,i;

	/* run back to find function name */
	first = scnt;
	while ((first>0) && (stab[first].type != FUNCTION) && (stab[first].type != SFUNCTION)) first--;
	first++;

	/* run forward to find parameters */
	last=first;
	while ((last<=scnt) && ((stab[last].stat==ADRPAR) || (stab[last].stat==VALPAR) || (stab[last].type==DUMMYPAR))) last++;
	last--;

	/* check no symbols are still DUMMYPAR */
	for (i=first;i<last;i++) if (stab[i].type==DUMMYPAR) {
		warning("undefined dummy parameter:",stab[i].name);
	}

	/* set lo,hi values in function entry for speed of CALL */
	stab[first-1].lo=first;
	stab[first-1].hi=last;
}

/* check value of return expression matches declaration */
void checkreturn(entry,t)
int	entry;
int	t;
{
	if (entry==0)
		warning("return expressions in functions only",NULL);
	else if (stab[entry].type != t)
		warning("return expression of wrong type",NULL);
}

/* check correct number of parameters to function */
void checkcall(entry,last)
int	entry;
int	last;
{
	if (stab[entry].hi != last)
		warning("incorrect number of parameters",stab[entry].name);
}

/* compile regular expression */
int patcomp(entry)
int	entry;
{
	char	*s,*regcmp();
	s=stab[entry].u.str;
	stab[entry].u.str=regcmp(s);
	Free(s);
	if (stab[entry].u.str == NULL)
		return(1);
	else
		return(0);
}
