/* getitem -- load a data item directly into buffer */

/* sfs implementation - July 1987 */

#include "SFSCONFG.h"
#include <stdio.h>
#include "sfs.h"

void getitem(filename,it,ty,item,buff)
char	*filename;		/* data file name */
int32	it;			/* item type */
char	*ty;			/* item specification */
struct item_header *item;	/* returned item header */
void	**buff;			/* returned buffer address */
{
	int	fid;
	char	errormessage[100];

	/* open file */
	if ((fid=sfsopen(filename,"r",NULL)) < 0) {
		if (fid == -1)
			error("unable to find %s",filename);
		else
			error("access error on %s",filename);
	}

	/* find item */
	sprintf(errormessage,"%d in %s",it,filename);
	if (!sfsitem(fid,it,ty,item))
		error("cannot find required item %s",errormessage);

	/* get buffer */
	sprintf(errormessage,"%d.%02d in %s",item->datatype,item->subtype,filename);
	if ((*buff=(void *)sfsbuffer(item,item->numframes))==NULL) 
		error("cannot get buffer for item %s",errormessage);

	/* read data */
	if (sfsread(fid,0,item->numframes,*buff) != item->numframes)
		error("could not load item %s",errormessage);

	sfsclose(fid);
}

#ifdef IAG
main()
{
	char	filename[80];
	struct item_header item;
	short	*sp;

	printf("Enter filename : ");
	fflush(stdout);
	scanf("%s",filename);

	getitem(filename,SP_TYPE,"0",&item,&sp);

	printf("Speech item %d.%02d loaded, first sample=%d, last sample=%d\n",
		item.datatype,item.subtype,sp[0],sp[item.numframes-1]);

}
#endif
