/* getopt -- get option letter from command line arguments */

/* replacement for Unix getopt */

/* m.a.huckvale */

/* version 1.0 - june 1987 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include <ctype.h>

/* external variables */
int     optind=1;
char    *optarg;
static int curroptind=1;
static char *curroptarg=NULL;

int     getopt(argc,argv,optstring)
int     argc;
char    **argv;
char    *optstring;
{
        char    *opt;

        optarg=NULL;
        /* check not off end of argument list */
        if (optind >= argc) return(EOF);
        /* check new arguments begin with '-' */
        if (!curroptarg) {
                curroptarg = argv[optind];
                if (*curroptarg != '-') return(EOF);
                curroptarg++;
        }
        /* let '--' terminate argument list regardless */
        if (*curroptarg=='-') {
                curroptarg=NULL;
                optind++;
                return(EOF);
        }
        /* look up argument letter on option string */
        opt=optstring;
        while ((*opt) && (*opt != *curroptarg)) opt++;
        /* if not found - error */
        if (*opt!=*curroptarg) {
                fprintf(stderr,"illegal option '%c'\n",*curroptarg);
                curroptarg=NULL;
                optind++;
                return('?');
        }
        /* if next option is not ':' then everything ok */
        if (*(opt+1) != ':') {
                curroptarg++;
                if (!*curroptarg) {
                        curroptarg=NULL;
                        optind++;
                }
                return(*opt);
        }
        /* value to option required */
        curroptarg++;
        /* check if next argument */
        if (!*curroptarg) {
                curroptarg=NULL;
                optind++;
                optarg=argv[optind];
                optind++;
                return(*opt);
        }
        /* value part of this argument */
        optarg=curroptarg;
        curroptarg=NULL;
        optind++;
        return(*opt);
}

