/* lab_getmatch -- get history matches for code from label files */

/* global declarations */
#include "SFSCONFG.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "sfs.h"
#include "label.h"

char	*lab_getmatch(code)
char	*code;
{
	char	*getenv(),*lab_match();
	char	*p,*m,path[256];

	if ((p = getenv("SFSLABEL")) == NULL) {
		strcpy(path,sfsbase());
		strcat(path,LABELFILE);
		return(lab_match(path,code));
	}
	else {
		strcpy(lab_hold2,"");
		strncpy(path,p,256);
		p=strtok(path,";");
		while (p) {
			m=lab_match(p,code);
			if ((m) && (strlen(lab_hold2)+strlen(m)) < MAXSTRING) 
				strcat(lab_hold2,m);
			p=strtok(0,";");
		}
		if (lab_hold2[0])
			return(lab_hold2);
		else
			return(NULL);
	}
}

#ifdef IAG
main()
{
	char	code[80];
	char	*match;

	for (;;) {
		printf("Enter code match : ");
		fflush(stdout);
		scanf("%s",code);
		match = lab_getmatch(code);
		printf("match='%s'\n",match);
	}
}
#endif
