/* lab_match -- return history match given short code */

/* global declarations */
#include "SFSCONFG.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include "sfs.h"
#include "label.h"

static char *getrec();

char	*lab_match(filename,code)
char	*filename;
char	*code;
{
	FILE		*ip;
	int32		mstart,mend,cstart,cend;
	int		mmax,cmax;
	struct stat	st;
	time_t		tim;
	char		*rec,*h,*e,*getrec(),c;
	int		lo,hi,md,numrec;
	int		m;
	int32		pos;

	/* try and open file */
	if ((ip=fopen(filename,"r"))==NULL)
		return(NULL);

	/* get info line */
	if (fscanf(ip,"#prolab %ld %d %d %d %d %d %d",&tim,&mstart,&mend,&mmax,&cstart,&cend,&cmax) != 7) {
		fprintf(stderr,"lab_match: bad labels file '%s'\n",filename);
		fclose(ip);
		return(NULL);
	}
#ifdef DOS
	mmax++;		/* account for CR + LF in DOS */
	cmax++;		/* account for CR + LF in DOS */
#endif

	/* get modification time of file */
	stat(filename,&st);
	if (st.st_mtime > (tim+5)) {
		fprintf(stderr,"lab_match: out of date labels file '%s'\n",filename);
		fprintf(stderr,"file=%ld time=%ld\n",(long)st.st_mtime,(long)tim+5);
		fclose(ip);
		return(NULL);
	}

	/* find first and last entries */
	numrec = ((cend-cstart)/cmax) - 1;

	/* binary chop */
	lo=0;
	hi=numrec;
	do {
		md=(hi+lo)/2;
		rec=getrec(ip,cstart+md*cmax,&pos);
		if ((m=strcmp(code,rec)) < 0)
			hi=md-1;
		else if (m > 0)
			lo=md+1;
	} while (!((m == 0) || (lo > hi)));

	/* check something found */
	if (m) return(NULL);

	/* run back to find first */
	while ((m==0) && (md > 0)) {
		md--;
		rec=getrec(ip,cstart+md*cmax,&pos);
		m = strcmp(code,rec);
	}
	if (m != 0) md++;

	/* run forward until no further match */
	h = lab_hold;
	e = &lab_hold[MAXSTRING];
	rec=getrec(ip,cstart+md*cmax,&pos);
	while ((md <= numrec) && (strcmp(code,rec)==0)) {
		fseek(ip,pos,0);
		while (((c=getc(ip)) != ':') && (c != EOF) && (h < e)) *h++ = c;
		if (h < e) *h++ = '\033';
		md++;
		rec=getrec(ip,cstart+md*cmax,&pos);
	}
	*h='\0';

	fclose(ip);

	return(lab_hold);
}

static char *getrec(ip,start,pos)
FILE		*ip;
int32		start;
int32		*pos;
{
	static char line[256];
	register char	*p;

	fseek(ip,start,0);
	fgets(line,256,ip);
	line[strlen(line)-1]='\0';
	*pos = atoi(&line[1]);
	p = &line[8];
	while (*p && (*p != '#')) p++;
	*p='\0';
	return(&line[8]);
}

#ifdef IAG
main()
{
	char	filename[80];
	char	code[80];
	char	*match;

	printf("Enter label filename : ");
	fflush(stdout);
	scanf("%s",filename);

	for (;;) {
		printf("Enter code match : ");
		fflush(stdout);
		scanf("%s",code);
		match = lab_match(filename,code);
		printf("match='%s'\n",match);
	}
}
#endif
