/* putitem -- update file with item stored in memory buffer */

/* sfs implementation - July 1987 */

#include "SFSCONFG.h"
#include <stdio.h>
#include "sfs.h"

void putitem(filename,item,numf,buff)
char	*filename;		/* database file to be updated */
struct	item_header *item;	/* item header to be written */
int32	numf;			/* # frames to write */
void	*buff;			/* memory buffer containing data */
{
	int	fid;

	/* create output channel */
	if ((fid=sfschannel(filename,item)) < 0)
		error("could not open output channel",NULL);

	/* write data to channel */
	if (sfswrite(fid,numf,buff) != numf)
		error("write error on temporary file",NULL);

	/* update data file */
	if (!sfsupdate(filename))
		error("update error on %s",filename);

}

#ifdef IAG
main()
{
	char	filename[80],spec[80];
	struct item_header item,newitem;
	char	*buff,*ty;
	int	fid,it;

	printf("Enter filename : ");
	fflush(stdout);
	scanf("%s",filename);
	if ((fid=sfsopen(filename,"r",NULL)) < 0) 
		error("cannot open %s",filename);

	printf("Enter item spec : ");
	fflush(stdout);
	scanf("%s",spec);
	if (itspec(spec,&it,&ty)!=0)
		error("bad item spec: %s",spec);

	if (!sfsitem(fid,it,ty,&item))
		error("cannot find item %s",spec);

	if ((buff=sfsbuffer(&item,item.numframes))==NULL)
		error("could not create memory buffer",NULL);

	if (sfsread(fid,0,item.numframes,buff) != item.numframes)
		error("could not read data set",NULL);

	sfsheader(&newitem,item.datatype,item.floating,
			item.datasize,item.framesize,
			item.frameduration,item.offset,
			item.windowsize,item.overlap,
			item.lxsync);
	sprintf(newitem.history,"putitem(%d.%02d)",
		item.datatype,item.subtype);
	strcpy(newitem.params,"");

	close(fid);
	putitem(filename,&newitem,item.numframes,buff);

	printf("added copy of selected item in %s\n",filename);
	exit(0);
}
#endif
