/* sfsbuffer -- memory allocation routine for speech data */

/* M.A.Huckvale -- July 1987 */

#include "SFSCONFG.h"
#include <stdio.h>
#include <malloc.h>
#include "sfs.h"

void	*sfsbuffer(item,numf)
struct item_header	*item;
int32			numf;
{
	int	fsize,fhead;
	char	*ptr=NULL;
	char	**s,*d;
	int32	i,esize;

	/* check out */
	if ((item->datatype < 1) ||
	    (item->datatype > MAXDATATYPE) ||
	    (numf < 0))
		return((char *)0);
	if (numf==0) numf=1;

	/* create suitable buffer */
	fsize = item->datasize * item->framesize;
	fhead = sfsstruct[item->datatype];
	if (fhead == 0) {
		/* unstructured data */
		if ((ptr = malloc(numf * fsize))==NULL)
			return(NULL);
	}
	else if (item->framesize > 0) {
		/* fixed-length structured data */
		if ((ptr = malloc(numf * (fsize + sizeof(char *))))==NULL)
			return(NULL);
		s = (char **)(ptr + fhead);
		d = ptr + numf * (fhead + sizeof(char *));
		for (i=0;i<numf;i++) {
			*s = d;
			s  = (char **)((char *) s + fhead + sizeof(char *));
			d += (fsize - fhead);
		}
	}
	else {
		/* variable length structures */
		fsize = 256;					/* maximum allowed */
		esize = numf * (fsize + sizeof(char *));	/* upper estimate */
		if ((item->length==0) || (item->datapresent==2)) {
			/* no idea how much room - allocate max */
			if ((ptr = malloc(esize))==NULL)
				return(NULL);
			/* initialise pointers in user output buffer */
			s = (char **)(ptr + fhead);
			d = ptr + numf * (fhead + sizeof(char *));
			for (i=0;i<numf;i++) {
				*s = d;
				s  = (char **)((char *) s + fhead + sizeof(char *));
				d += (fsize - fhead);
			}
		}
		else {
			/* smallest of item->length and upper estimate */
			if (item->length < esize) {
				if ((ptr = malloc(item->length + numf * (sizeof(char *) + 1)))==NULL)
					return(NULL);
			}
			else {
				if ((ptr = malloc(esize))==NULL)
					return(NULL);
			/* NOTE: sfsread copes with NULL pointers for variable length recs */
			}
		}
	}
	return(ptr);
}
