/* sfsconvm -- convert main header formats */

/* version 1.0 - june 1987 */

#include "SFSCONFG.h"
#include <stdio.h>
#include "sfs.h"

/* macros to reverse ints and floats */
#define REVERSE4(x)	p = (unsigned char *)&x; \
			t = *p; *p = *(p+3); *(p+3) = t; \
			t = *++p; *p = *(p+1); *(p+1) = t;
#define REVERSE8(x)	p = (unsigned char *)&x; \
			t = *p; *p = *(p+7); *(p+7) = t; \
			t = *++p; *p = *(p+5); *(p+5) = t; \
			t = *++p; *p = *(p+3); *(p+3) = t; \
			t = *++p; *p = *(p+1); *(p+1) = t;

void sfsconvm(head)
struct main_header 	*head;
{
	register unsigned char	*p,t;

	/* convert 8086 to 68000 */
	if (((head->machine & 0xFF)==1) && (SFSMACHINE==0)) {
		REVERSE4(head->creatdate);
		head->creatdate -= 28800;
		REVERSE4(head->fid.num);
	}
	else if (((head->machine & 0xFF)==0) && ((SFSMACHINE & 0xFF)==1)) {
		REVERSE4(head->creatdate);
		head->creatdate += 28800;
		REVERSE4(head->fid.num);
	}
}
