/* escopy -- Es routines for copying and linking items */

/* M.A.Huckvale - University College London */

/* version 1.0 - August 1993 */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/file.h>
#include <fcntl.h>
#ifdef DOS
#include <io.h>
#endif
#include "sfs.h"
#include "sfsdata.h"
#include "es.h"
#define MIN(x,y) (((x)<(y))?(x):(y))

/* check if SFS file exists and OK to write to */
int escheckfile(fname)
char	*fname;
{
	int	fid;

	if (access(fname,F_OK)!=0)
		return(ES_NOEXIST);
	else if (access(fname,W_OK)!=0)
		return(ES_NOWRITE);
	else if ((fid=sfsopen(fname,"w",NULL)) < 0)
		return(ES_NOTSFS);
	else {
		sfsclose(fid);
		return(ES_OK);
	}
}

/* copy sections from an item list */
int escopyitem(ifilename,fid,itemlist,itlistno,start,stop,ofilename)
char			*ifilename;
int			fid;
struct itemno_rec	*itemlist;
int			itlistno;
double			start,stop;
char			*ofilename;
{
	int		bufsize;
	int		bstart,numf;
	int		copies=0;
	double		fdur,correction=0;
	char		*buff;
	int		cnt;
	int		ofid;
	struct item_header ipitem;
	struct item_header opitem;
	extern char	*progname;

	sfsnextitem(fid,NULL);
	while (sfsnextitem(fid,&ipitem)) {
		/* do copying if simple to do so */
		if (onitemlist(itemlist,itlistno,ipitem.datatype,ipitem.subtype) &&
			(ipitem.lxsync==0) &&
			(ipitem.datatype != TX_TYPE) &&
			(ipitem.datatype != AN_TYPE)) {

			/* get amount to copy */
			if (sfsstruct[ipitem.datatype]==0) {
				/* unstructured item */
				fdur = ipitem.frameduration;
				correction = 0; /* should set to alignment error */
			}
			else {
				/* fixed window structured */
				fdur = (ipitem.windowsize-ipitem.overlap)*ipitem.frameduration;
				correction = -start;
			}

			bstart = (int)((start-ipitem.offset)/fdur);
			numf = (int)((stop-ipitem.offset)/fdur - bstart + 1);
			if (bstart < 0) bstart=0;
			if (bstart >= ipitem.numframes) bstart = ipitem.numframes-1;
			if ((bstart+numf) > ipitem.numframes)
				numf = ipitem.numframes - bstart;
			if (numf <= 0)
				continue;

			/* make output header */
			sfsheader(&opitem,
				ipitem.datatype,
				ipitem.floating,
				ipitem.datasize,
				ipitem.framesize,
				ipitem.frameduration,
				correction,
				sfsstruct[ipitem.datatype]?0:ipitem.windowsize,
				sfsstruct[ipitem.datatype]?0:ipitem.overlap,
				sfsstruct[ipitem.datatype]?1:ipitem.lxsync);

			sprintf(opitem.history,"%s(file=%s,item=%d.%02d,start=%g,stop=%g,history=%s)",
				progname,ifilename,
				ipitem.datatype,ipitem.subtype,
				start,stop,
				ipitem.history);
			strcpy(opitem.params,ipitem.params);

			/* open output channel */
			if ((ofid=sfschannel(ofilename,&opitem)) < 0)
				continue;
		
			/* get a copy buffer */
			bufsize = 32768/(ipitem.datasize*ipitem.framesize);
			if ((buff=(char *)sfsbuffer(&ipitem,bufsize))==NULL)
				continue;

			/* do the copying */
			while (numf > 0) {
				cnt=sfsread(fid,bstart,MIN(numf,bufsize),buff);
				if (cnt<=0)
					error("read error on '%s'",ifilename);
				if (sfswrite(ofid,cnt,buff)!=cnt)
					error("write error on '%s'",ofilename);
				bstart += cnt;
				numf -= cnt;
			}

			/* lose the buffer */
			free(buff);

			/* update the file from time to time */
			if ((++copies%10)==0)
				sfsupdate(ofilename);
		}
	}

	if (copies)
		sfsupdate(ofilename);
	return(copies);
}

/* link sections from an item list */
int eslinkitem(ifilename,fid,itemlist,itlistno,start,stop,ofilename)
char			*ifilename;
int			fid;
struct itemno_rec	*itemlist;
int			itlistno;
double			start,stop;
char			*ofilename;
{
	int		bstart,numf;
	int		copies=0;
	double		fdur,correction=0;
	struct item_header ipitem;
	struct item_header opitem;
	struct link_header oplink;
	extern char	*progname;

	sfsnextitem(fid,NULL);
	while (sfsnextitem(fid,&ipitem)) {
		/* link part or whole of dataset */
		if (onitemlist(itemlist,itlistno,ipitem.datatype,ipitem.subtype)) {

			if ((ipitem.lxsync==0) &&
			    (ipitem.datatype != TX_TYPE) &&
			    (ipitem.datatype != AN_TYPE)) {

				/* get amount to copy */
				if (sfsstruct[ipitem.datatype]==0) {
					/* unstructured item */
					fdur = ipitem.frameduration;
					correction = 0; /* should set to alignment error */
				}
				else {
					/* fixed window structured */
					fdur = (ipitem.windowsize-ipitem.overlap)*ipitem.frameduration;
					correction = -start;
				}

				bstart = (int)((start-ipitem.offset)/fdur);
				numf = (int)((stop-ipitem.offset)/fdur - bstart + 1);
				if (bstart < 0) bstart=0;
				if (bstart >= ipitem.numframes) bstart = ipitem.numframes-1;
				if ((bstart+numf) > ipitem.numframes)
					numf = ipitem.numframes - bstart;
				if (numf <= 0)
					continue;

				/* make output header */
				sfsheader(&opitem,
					ipitem.datatype,
					ipitem.floating,
					ipitem.datasize,
					ipitem.framesize,
					ipitem.frameduration,
					correction,
					sfsstruct[ipitem.datatype]?0:ipitem.windowsize,
					sfsstruct[ipitem.datatype]?0:ipitem.overlap,
					sfsstruct[ipitem.datatype]?1:ipitem.lxsync);
				sprintf(opitem.history,"%s(link,file=%s,item=%d.%02d,start=%g,stop=%g,history=%s)",
					progname,ifilename,
					ipitem.datatype,ipitem.subtype,
					start,stop,
					ipitem.history);
				strcpy(opitem.params,ipitem.params);

				if (ipitem.datapresent==2) {
					/* resolve existing link */
					lseek(fid,sfsdata[fid]->datastart,0);
					read(fid,&oplink,sizeof(struct link_header));
					sfsdata[fid]->currpos=lseek(fid,0L,1);
					oplink.offset += bstart*ipitem.datasize*ipitem.framesize;
				}
				else {
					/* create link header */
					memset((char *)&oplink,0,sizeof(struct link_header));
					strcpy(oplink.filename,pathname(ifilename));
					oplink.filetype = SFS_TYPE;
					oplink.datatype = ipitem.datatype;
					oplink.subtype = ipitem.subtype;
					oplink.offset = bstart*ipitem.datasize*ipitem.framesize;
					oplink.linkdate = ipitem.processdate;
					oplink.machine = ipitem.machine;
				}
	
				/* write link header to file */
				if (!sfswritelink(&opitem,numf,&oplink,ofilename))
					error("write failed on temporary file",NULL);

				/* update the file from time to time */
				if ((++copies%10)==0)
					sfsupdate(ofilename);
			}
		}
	}

	if (copies)
		sfsupdate(ofilename);
	return(copies);
}

